#!/bin/sh

declare DISTCCD="/users/chaos/kane/Softwares/distcc/bin/distccd";
declare DISTCC_NICE="0";
declare DISTCC_ADDRESS="132.227.0.0/16";

#-----[ distcc_usage ]---------------------------------------------
function distcc_usage ()
{
    echo "Usage : ${0} {start|stop|restart|status|uptime|clean|help}";
    #exit 1;
}

#-----[ distcc_start ]---------------------------------------------
function distcc_start ()
{
    echo  "Starting distcc services";

    ${DISTCCD} --nice ${DISTCC_NICE} --daemon --allow ${DISTCC_ADDRESS};

    return $?;
}

#-----[ distcc_stop ]----------------------------------------------
function distcc_stop ()
{
    echo  "Shutting down distcc services";

    killall ${DISTCCD};

    return $?;
}

#-----[ distcc_status ]--------------------------------------------
function distcc_status ()
{
    test $(ps aux | grep -c ${DISTCCD}) -gt 1;

    RET=${?};

    if test ${RET} -eq 0; then
        echo "distcc is running";
    else
        echo "distcc is not running";
    fi;

    return ${RET};
}

#-----[ distcc_uptime ]--------------------------------------------
function distcc_uptime ()
{
    uptime;

    return $?;
}

#-----[ distcc_clean ]---------------------------------------------
function distcc_clean ()
{
    rm -fr /tmp/*;

    return $?;
}

#-----[ distcc_main ]----------------------------------------------
function distcc_main ()
{
    # Test operand
    if test ${#} -ne 1; then
	distcc_usage ${*};
    else
        case ${1} in
	    "start")
	        distcc_start;
	        
	        ;;
	    "stop")
	        distcc_stop;
	        ;;
	    "restart")
	        distcc_stop;
	        distcc_start;
	        ;;
	    "status")
	        distcc_status;
	        ;;
	    "uptime")
	        distcc_uptime;
	        ;;
	    "clean")
	        distcc_clean;
	        ;;
	    *)
	        distcc_usage ${*};
        esac;
    fi;

    unset DISTCCD;
    unset DISTCC_NICE;
    unset DISTCC_ADDRESS;

    #exit $?;
}

#-----[ Body ]----------------------------------------------
distcc_main ${*};
