/*
 * $Id: Reservation_station.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Reservation_station.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace reservation_station {


#undef  FUNCTION
#define FUNCTION "Reservation_station::Reservation_station"

  Reservation_station::Reservation_station 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   std::string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::reservation_station::Parameters * param,
   morpheo::behavioural::Tusage_t                usage ):
    _name   (name)
    ,_param (param)
    ,_usage (usage)
  {
    log_printf(FUNC,Reservation_station,FUNCTION,_("<%s> Begin"),_name.c_str());

// #if DEBUG_Reservation_station == true
//     log_printf(INFO,Reservation_station,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

#ifdef SYSTEMC
    log_printf(INFO,Reservation_station,FUNCTION,_("<%s> Allocation"),_name.c_str());

    allocation ();
#endif

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
        log_printf(INFO,Reservation_station,FUNCTION,_("<%s> Allocation of statistics"),_name.c_str());
        
        statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {	
        // generate the vhdl
        log_printf(INFO,Reservation_station,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
        
        vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {	
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    log_printf(INFO,Reservation_station,FUNCTION,_("<%s> Method - transition"),_name.c_str());

    SC_METHOD (transition);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).pos();
//#endif

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

    log_printf(INFO,Reservation_station,FUNCTION,_("<%s> Method - genMoore"),_name.c_str());

    SC_METHOD (genMoore);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).neg();

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    
      }
#endif
    log_printf(FUNC,Reservation_station,FUNCTION,_("<%s> End"),_name.c_str());
  };
  
#undef  FUNCTION
#define FUNCTION "Reservation_station::~Reservation_station"
  Reservation_station::~Reservation_station (void)
  {
    log_printf(FUNC,Reservation_station,FUNCTION,_("<%s> Begin"),_name.c_str());

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
        log_printf(INFO,Reservation_station,FUNCTION,_("<%s> Generate Statistics file"),_name.c_str());
        
        delete _stat;
      }
#endif

#ifdef SYSTEMC
    log_printf(INFO,Reservation_station,FUNCTION,_("<%s> Deallocation"),_name.c_str());

    deallocation ();
#endif

    log_printf(FUNC,Reservation_station,FUNCTION,_("<%s> End"),_name.c_str());
  };

}; // end namespace reservation_station
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
