/*
 * $Id: Execute_queue_allocation.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Wrapper_Execute_queue.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {

#undef  FUNCTION
#define FUNCTION "Execute_queue::allocation"
  void Execute_queue::allocation (void)
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,_param->_type
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

    // -----[ Interface "execute_queue_in" ]--------------------------------    
     {
       ALLOC0_INTERFACE_BEGIN("execute_queue_in", IN, WEST, "Input of execute_queue");
       
       ALLOC0_VALACK_IN ( in_EXECUTE_QUEUE_IN_VAL,VAL);
       ALLOC0_VALACK_OUT(out_EXECUTE_QUEUE_IN_ACK,ACK);
       ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_CONTEXT_ID   ,"context_id"   ,Tcontext_t        ,_param->_size_context_id         );
       ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_FRONT_END_ID ,"front_end_id" ,Tcontext_t        ,_param->_size_front_end_id       );
       ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id      );
       ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_PACKET_ID    ,"packet_id"    ,Tpacket_t         ,_param->_size_rob_ptr            );
//     ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_OPERATION    ,"operation"    ,Toperation_t      ,_param->_size_operation          );
//     ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_TYPE         ,"type"         ,Ttype_t           ,_param->_size_type               );
       ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_CANCEL       ,"cancel"       ,Tcontrol_t        ,1                                );
       ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_FLAGS        ,"flags"        ,Tspecial_data_t   ,_param->_size_special_data       );
       ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_EXCEPTION    ,"exception"    ,Texception_t      ,_param->_size_exception          );
       ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_NO_SEQUENCE  ,"no_sequence"  ,Tcontrol_t        ,1                                );
       ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_ADDRESS      ,"address"      ,Taddress_t        ,_param->_size_instruction_address);
       ALLOC0_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_DATA         ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data       );

       ALLOC0_INTERFACE_END();
     }

    // -----[ Interface "execute_queue_out" ]-------------------------------
     {
       ALLOC0_INTERFACE_BEGIN("execute_queue_out", OUT, EAST, "Output of execute_queue");
       
       ALLOC0_VALACK_OUT(out_EXECUTE_QUEUE_OUT_VAL,VAL);
       ALLOC0_VALACK_IN ( in_EXECUTE_QUEUE_OUT_ACK,ACK);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_CONTEXT_ID   ,"context_id"   ,Tcontext_t     ,_param->_size_context_id   );
       ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_FRONT_END_ID ,"front_end_id" ,Tcontext_t     ,_param->_size_front_end_id );
       ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t     ,_param->_size_ooo_engine_id);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_PACKET_ID    ,"packet_id"    ,Tpacket_t      ,_param->_size_rob_ptr    );
//     ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_OPERATION    ,"operation"    ,Toperation_t   ,_param->_size_operation    );
//     ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_TYPE         ,"type"         ,Ttype_t        ,_param->_size_type         );
       ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_CANCEL       ,"cancel"       ,Tcontrol_t     ,1                          );
       ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_FLAGS        ,"flags"        ,Tspecial_data_t,_param->_size_special_data );
       ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_EXCEPTION    ,"exception"    ,Texception_t   ,_param->_size_exception    );
       ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ,"no_sequence"  ,Tcontrol_t     ,1                          );
       ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_ADDRESS      ,"address"      ,Taddress_t     ,_param->_size_instruction_address);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_DATA         ,"data"         ,Tgeneral_data_t,_param->_size_general_data );

       ALLOC0_INTERFACE_END();
     }

     // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
     if (usage_is_set(_usage,USE_SYSTEMC_BODY))
       {
         _queue = new std::list<execute_queue_entry_t *>;
       }

     // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
        _param_queue = new morpheo::behavioural::generic::queue::Parameters
          (_param->_size_queue,
           _param->_size_internal_queue,
           0,
           false,
           false
           );
        
        std::string queue_name = _name + "_queue";
        _component_queue = new morpheo::behavioural::generic::queue::Queue
          (queue_name.c_str()
# ifdef STATISTICS
           ,NULL
# endif
           ,_param_queue
           ,USE_VHDL);
        
        _component->set_component(_component_queue->_component
# ifdef POSITION
                                  , 0, 0, 0, 0
# endif
                                  , INSTANCE_LIBRARY
                                  );
      }
#endif

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif
  
#ifdef MODELSIM_COSIMULATION
    if (usage_is_set(_usage,USE_COSIMULATION))
      {
        log_printf(INFO,Execute_queue,FUNCTION,_("<%s> : Create Wrapper"),_name.c_str());

        _wrapper = new Wrapper_Execute_queue(_name.c_str(),"morpheo_behavioural","/dsk/l1/misc/Morpheo/work",_param);
//      _wrapper = new Wrapper_Execute_queue(_name.c_str(),"morpheo_behavioural","work");

        log_printf(INFO,Execute_queue,FUNCTION,_("<%s> : Wrapper Instanciation"),_name.c_str());

//         INSTANCE0_FOREIGN_SIGNAL_CLOCK(_wrapper, in_CLOCK                                              , "in_CLOCK"                           ,1);
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_NRESET                          ,Tcontrol_t        , "in_NRESET"                          ,1);
                                                                                                                     
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_VAL            ,Tcontrol_t        , "in_EXECUTE_QUEUE_IN_VAL"            ,1                                );
//         INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_IN_ACK            ,Tcontrol_t        ,"out_EXECUTE_QUEUE_IN_ACK"            ,1                                );
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_CONTEXT_ID     ,Tcontext_t        , "in_EXECUTE_QUEUE_IN_CONTEXT_ID"     ,_param->_size_context_id         );
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_FRONT_END_ID   ,Tcontext_t        , "in_EXECUTE_QUEUE_IN_FRONT_END_ID"   ,_param->_size_front_end_id       );
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID  ,Tcontext_t        , "in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID"  ,_param->_size_ooo_engine_id      );
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_PACKET_ID      ,Tpacket_t         , "in_EXECUTE_QUEUE_IN_PACKET_ID"      ,_param->_size_rob_ptr            );
// //      INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_OPERATION      ,Toperation_t      , "in_EXECUTE_QUEUE_IN_OPERATION"      ,_param->_size_operation          );
// //      INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_TYPE           ,Ttype_t           , "in_EXECUTE_QUEUE_IN_TYPE"           ,_param->_size_type               );
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_FLAGS          ,Tspecial_data_t   , "in_EXECUTE_QUEUE_IN_FLAGS"          ,_param->_size_special_data       );
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_EXCEPTION      ,Texception_t      , "in_EXECUTE_QUEUE_IN_EXCEPTION"      ,_param->_size_exception          );
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_NO_SEQUENCE    ,Tcontrol_t        , "in_EXECUTE_QUEUE_IN_NO_SEQUENCE"    ,1                                );
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_ADDRESS        ,Taddress_t        , "in_EXECUTE_QUEUE_IN_ADDRESS"        ,_param->_size_instruction_address);
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_IN_DATA           ,Tgeneral_data_t   , "in_EXECUTE_QUEUE_IN_DATA"           ,_param->_size_general_data       );
                                                                                                                     
//         INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_VAL           ,Tcontrol_t        ,"out_EXECUTE_QUEUE_OUT_VAL"           ,1                                );
//         INSTANCE0_FOREIGN_SIGNAL_IN   (_wrapper, in_EXECUTE_QUEUE_OUT_ACK           ,Tcontrol_t        , "in_EXECUTE_QUEUE_OUT_ACK"           ,1                                );
//         INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_CONTEXT_ID    ,Tcontext_t        ,"out_EXECUTE_QUEUE_OUT_CONTEXT_ID"    ,_param->_size_context_id         );
//         INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_FRONT_END_ID  ,Tcontext_t        ,"out_EXECUTE_QUEUE_OUT_FRONT_END_ID"  ,_param->_size_front_end_id       );
//         INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID ,Tcontext_t        ,"out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID" ,_param->_size_ooo_engine_id      );
//         INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_PACKET_ID     ,Tpacket_t         ,"out_EXECUTE_QUEUE_OUT_PACKET_ID"     ,_param->_size_rob_ptr            );
// //      INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_OPERATION     ,Toperation_t      ,"out_EXECUTE_QUEUE_OUT_OPERATION"     ,_param->_size_operation          );
// //      INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_TYPE          ,Ttype_t           ,"out_EXECUTE_QUEUE_OUT_TYPE"          ,_param->_size_type               );
//         INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_FLAGS         ,Tspecial_data_t   ,"out_EXECUTE_QUEUE_OUT_FLAGS"         ,_param->_size_special_data       );
//         INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_EXCEPTION     ,Texception_t      ,"out_EXECUTE_QUEUE_OUT_EXCEPTION"     ,_param->_size_exception          );
//         INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_NO_SEQUENCE   ,Tcontrol_t        ,"out_EXECUTE_QUEUE_OUT_NO_SEQUENCE"   ,1                                );
//         INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_ADDRESS       ,Taddress_t        ,"out_EXECUTE_QUEUE_OUT_ADDRESS"       ,_param->_size_instruction_address);
//         INSTANCE0_FOREIGN_SIGNAL_OUT  (_wrapper,out_EXECUTE_QUEUE_OUT_DATA          ,Tgeneral_data_t   ,"out_EXECUTE_QUEUE_OUT_DATA"          ,_param->_size_general_data       );

        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_CLOCK                           ,Tcontrol_t     , "in_CLOCK"                           ,1);
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_NRESET                          ,Tcontrol_t     , "in_NRESET"                          ,1);
                                                                                            
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_VAL            ,Tcontrol_t     , "in_EXECUTE_QUEUE_IN_VAL"            ,1                                );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_IN_ACK            ,Tcontrol_t     ,"out_EXECUTE_QUEUE_IN_ACK"            ,1                                );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_CONTEXT_ID     ,Tcontext_t     , "in_EXECUTE_QUEUE_IN_CONTEXT_ID"     ,_param->_size_context_id         );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_FRONT_END_ID   ,Tcontext_t     , "in_EXECUTE_QUEUE_IN_FRONT_END_ID"   ,_param->_size_front_end_id       );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID  ,Tcontext_t     , "in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID"  ,_param->_size_ooo_engine_id      );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_PACKET_ID      ,Tpacket_t      , "in_EXECUTE_QUEUE_IN_PACKET_ID"      ,_param->_size_rob_ptr            );
//      INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_OPERATION      ,Toperation_t   , "in_EXECUTE_QUEUE_IN_OPERATION"      ,_param->_size_operation          );
//      INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_TYPE           ,Ttype_t        , "in_EXECUTE_QUEUE_IN_TYPE"           ,_param->_size_type               );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_CANCEL         ,Tcontrol_t     , "in_EXECUTE_QUEUE_IN_CANCEL"         ,1                                );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_FLAGS          ,Tspecial_data_t, "in_EXECUTE_QUEUE_IN_FLAGS"          ,_param->_size_special_data       );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_EXCEPTION      ,Texception_t   , "in_EXECUTE_QUEUE_IN_EXCEPTION"      ,_param->_size_exception          );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_NO_SEQUENCE    ,Tcontrol_t     , "in_EXECUTE_QUEUE_IN_NO_SEQUENCE"    ,1                                );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_ADDRESS        ,Taddress_t     , "in_EXECUTE_QUEUE_IN_ADDRESS"        ,_param->_size_instruction_address);
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_IN_DATA           ,Tgeneral_data_t, "in_EXECUTE_QUEUE_IN_DATA"           ,_param->_size_general_data       );
                                                                                            
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_VAL           ,Tcontrol_t     ,"out_EXECUTE_QUEUE_OUT_VAL"           ,1                                );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper, in_EXECUTE_QUEUE_OUT_ACK           ,Tcontrol_t     , "in_EXECUTE_QUEUE_OUT_ACK"           ,1                                );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_CONTEXT_ID    ,Tcontext_t     ,"out_EXECUTE_QUEUE_OUT_CONTEXT_ID"    ,_param->_size_context_id         );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_FRONT_END_ID  ,Tcontext_t     ,"out_EXECUTE_QUEUE_OUT_FRONT_END_ID"  ,_param->_size_front_end_id       );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID ,Tcontext_t     ,"out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID" ,_param->_size_ooo_engine_id      );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_PACKET_ID     ,Tpacket_t      ,"out_EXECUTE_QUEUE_OUT_PACKET_ID"     ,_param->_size_rob_ptr            );
//      INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_OPERATION     ,Toperation_t   ,"out_EXECUTE_QUEUE_OUT_OPERATION"     ,_param->_size_operation          );
//      INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_TYPE          ,Ttype_t        ,"out_EXECUTE_QUEUE_OUT_TYPE"          ,_param->_size_type               );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_CANCEL        ,Tcontrol_t     ,"out_EXECUTE_QUEUE_OUT_CANCEL"        ,1                                );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_FLAGS         ,Tspecial_data_t,"out_EXECUTE_QUEUE_OUT_FLAGS"         ,_param->_size_special_data       );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_EXCEPTION     ,Texception_t   ,"out_EXECUTE_QUEUE_OUT_EXCEPTION"     ,_param->_size_exception          );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_NO_SEQUENCE   ,Tcontrol_t     ,"out_EXECUTE_QUEUE_OUT_NO_SEQUENCE"   ,1                                );
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_ADDRESS       ,Taddress_t     ,"out_EXECUTE_QUEUE_OUT_ADDRESS"       ,_param->_size_instruction_address);
        INSTANCE0_FOREIGN_SIGNAL(_wrapper,out_EXECUTE_QUEUE_OUT_DATA          ,Tgeneral_data_t,"out_EXECUTE_QUEUE_OUT_DATA"          ,_param->_size_general_data       );

        log_printf(INFO,Execute_queue,FUNCTION,_("<%s> : Wrapper Instanciation end"),_name.c_str());
      }
#endif
      
    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
