#ifdef VHDL
/*
 * $Id: Execute_queue_vhdl_body.cpp 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {


#undef  FUNCTION
#define FUNCTION "Execute_queue::vhdl_body"
  void Execute_queue::vhdl_body (Vhdl * & vhdl)
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");

    vhdl->set_comment(0,"");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"-- Instance queue                  ");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"");

    vhdl->set_body   (0,"instance_"+_name+"_queue : "+_name+"_queue");
    vhdl->set_body   (0,"port map (");
    vhdl->set_body   (1,"  in_CLOCK       \t=>\t      in_CLOCK ");
    vhdl->set_body   (1,", in_NRESET      \t=>\t      in_NRESET");
    vhdl->set_body   (1,", in_INSERT_VAL  \t=>\tinternal_QUEUE_INSERT_VAL");
    vhdl->set_body   (1,",out_INSERT_ACK  \t=>\tinternal_QUEUE_INSERT_ACK");
    vhdl->set_body   (1,", in_INSERT_DATA \t=>\tinternal_QUEUE_INSERT_DATA");
    vhdl->set_body   (1,",out_RETIRE_VAL  \t=>\tinternal_QUEUE_RETIRE_VAL");
    vhdl->set_body   (1,", in_RETIRE_ACK  \t=>\tinternal_QUEUE_RETIRE_ACK");
    vhdl->set_body   (1,",out_RETIRE_DATA \t=>\tinternal_QUEUE_RETIRE_DATA");
    vhdl->set_body   (0,");");

    vhdl->set_comment(0,"");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"-- Input  Buffer                   ");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"");

    {
    uint32_t min = 0;
    uint32_t max, size;

    if(_param->_have_port_context_id   )
      {
    size = _param->_size_context_id;
    max = min-1+size;
    vhdl->set_body   (0,"internal_QUEUE_INSERT_DATA "+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_EXECUTE_QUEUE_IN_CONTEXT_ID "+std_logic_range(size)+";");
    min = max+1;
      }
    if(_param->_have_port_front_end_id   )
      {
    size = _param->_size_front_end_id;
    max = min-1+size;
    vhdl->set_body   (0,"internal_QUEUE_INSERT_DATA "+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_EXECUTE_QUEUE_IN_FRONT_END_ID"+std_logic_range(size)+";");
    min = max+1;
      }
    if(_param->_have_port_ooo_engine_id   )
      {
    size = _param->_size_ooo_engine_id;
    max = min-1+size;
    vhdl->set_body   (0,"internal_QUEUE_INSERT_DATA "+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID"+std_logic_range(size)+";");
    min = max+1;
      }
    if(_param->_have_port_rob_ptr)
      {
    size = _param->_size_rob_ptr;
    max = min-1+size;
    vhdl->set_body   (0,"internal_QUEUE_INSERT_DATA "+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_EXECUTE_QUEUE_IN_PACKET_ID"+std_logic_range(size)+";");
    min = max+1;
      }

//  size = _param->_size_operation;
//  max = min-1+size;
//  vhdl->set_body   (0,"internal_QUEUE_INSERT_DATA "+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_EXECUTE_QUEUE_IN_OPERATION"+std_logic_range(size)+";");
//  min = max+1;
//
//  size = _param->_size_type;
//  max = min-1+size;
//  vhdl->set_body   (0,"internal_QUEUE_INSERT_DATA "+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_EXECUTE_QUEUE_IN_TYPE"+std_logic_range(size)+";");
//  min = max+1;

    size = _param->_size_special_data;
    max = min-1+size;
    vhdl->set_body   (0,"internal_QUEUE_INSERT_DATA "+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_EXECUTE_QUEUE_IN_FLAGS"+std_logic_range(size)+";");
    min = max+1;

    size = _param->_size_exception;    
    max = min-1+size;
    vhdl->set_body   (0,"internal_QUEUE_INSERT_DATA "+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_EXECUTE_QUEUE_IN_EXCEPTION"+std_logic_range(size)+";");
    min = max+1;

    size = 1;
    max = min-1+size;
    vhdl->set_body   (0,"internal_QUEUE_INSERT_DATA "+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_EXECUTE_QUEUE_IN_NO_SEQUENCE"+std_logic_range(size)+";");
    min = max+1;

    size = _param->_size_instruction_address;
    max = min-1+size;
    vhdl->set_body   (0,"internal_QUEUE_INSERT_DATA "+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_EXECUTE_QUEUE_IN_ADDRESS"+std_logic_range(size)+";");
    min = max+1;

    size = _param->_size_general_data;
    max = min-1+size;
    vhdl->set_body   (0,"internal_QUEUE_INSERT_DATA "+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_EXECUTE_QUEUE_IN_DATA"+std_logic_range(size)+";");
    min = max+1;
    }

    vhdl->set_comment(0,"");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"-- Output Buffer                   ");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"");

    if(_param->_have_port_context_id)
    vhdl->set_body   (0,"out_EXECUTE_QUEUE_OUT_CONTEXT_ID    "+std_logic_range(_param->_size_context_id         )+" <= internal_EXECUTE_QUEUE_OUT_CONTEXT_ID   ;");
    if(_param->_have_port_front_end_id)
    vhdl->set_body   (0,"out_EXECUTE_QUEUE_OUT_FRONT_END_ID  "+std_logic_range(_param->_size_front_end_id       )+" <= internal_EXECUTE_QUEUE_OUT_FRONT_END_ID ;");
    if(_param->_have_port_ooo_engine_id)
    vhdl->set_body   (0,"out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID "+std_logic_range(_param->_size_ooo_engine_id      )+" <= internal_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID;");
    if(_param->_have_port_rob_ptr)
    vhdl->set_body   (0,"out_EXECUTE_QUEUE_OUT_PACKET_ID     "+std_logic_range(_param->_size_rob_ptr            )+" <= internal_EXECUTE_QUEUE_OUT_PACKET_ID    ;");
//  vhdl->set_body   (0,"out_EXECUTE_QUEUE_OUT_OPERATION     "+std_logic_range(_param->_size_operation          )+" <= internal_EXECUTE_QUEUE_OUT_OPERATION    ;");
//  vhdl->set_body   (0,"out_EXECUTE_QUEUE_OUT_TYPE          "+std_logic_range(_param->_size_type               )+" <= internal_EXECUTE_QUEUE_OUT_TYPE         ;");
    vhdl->set_body   (0,"out_EXECUTE_QUEUE_OUT_FLAGS         "+std_logic_range(_param->_size_special_data       )+" <= internal_EXECUTE_QUEUE_OUT_FLAGS        ;");
    vhdl->set_body   (0,"out_EXECUTE_QUEUE_OUT_EXCEPTION     "+std_logic_range(_param->_size_exception          )+" <= internal_EXECUTE_QUEUE_OUT_EXCEPTION    ;");
    vhdl->set_body   (0,"out_EXECUTE_QUEUE_OUT_NO_SEQUENCE   "+std_logic_range(1                                )+" <= internal_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ;");
    vhdl->set_body   (0,"out_EXECUTE_QUEUE_OUT_ADDRESS       "+std_logic_range(_param->_size_instruction_address)+" <= internal_EXECUTE_QUEUE_OUT_ADDRESS      ;");
    vhdl->set_body   (0,"out_EXECUTE_QUEUE_OUT_DATA          "+std_logic_range(_param->_size_general_data       )+" <= internal_EXECUTE_QUEUE_OUT_DATA         ;");

//     vhdl->set_debug  ("in_CLOCK = 'U'","GLOP1: Clock = 'U'");
//     vhdl->set_debug  ("in_CLOCK = 'X'","GLOP2: Clock = 'X'");
//     vhdl->set_debug  ("in_CLOCK = 'Z'","GLOP3: Clock = 'Z'");
//     vhdl->set_debug  ("in_CLOCK = 'W'","GLOP4: Clock = 'W'");
//     vhdl->set_debug  ("in_CLOCK = '1'","KANE : Clock = '1'");
//     vhdl->set_debug  ("in_CLOCK = '0'","SETH : Clock = '0'");

    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
