/*
 * $Id: Decod_deallocation.cpp 139 2010-07-30 14:47:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Decod.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {


#undef  FUNCTION
#define FUNCTION "Decod::deallocation"
  void Decod::deallocation (void)
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

    if (_usage & USE_SYSTEMC)
      {
	delete    in_CLOCK ;
	delete    in_NRESET;
      
        DELETE2_SIGNAL( in_IFETCH_VAL                        ,_param->_nb_context,_param->_nb_inst_fetch[it1],1);
        DELETE2_SIGNAL(out_IFETCH_ACK                        ,_param->_nb_context,_param->_nb_inst_fetch[it1],1);
        DELETE2_SIGNAL( in_IFETCH_INSTRUCTION                ,_param->_nb_context,_param->_nb_inst_fetch[it1],_param->_size_instruction);
        DELETE2_SIGNAL( in_IFETCH_CONTEXT_ID                 ,_param->_nb_context,_param->_nb_inst_fetch[it1],_param->_size_context_id      );
        DELETE2_SIGNAL( in_IFETCH_ADDRESS                    ,_param->_nb_context,_param->_nb_inst_fetch[it1],_param->_size_instruction_address    );
//      DELETE2_SIGNAL( in_IFETCH_ADDRESS_NEXT               ,_param->_nb_context,_param->_nb_inst_fetch[it1],_param->_size_instruction_address    );
//      DELETE2_SIGNAL( in_IFETCH_INST_IFETCH_PTR            ,_param->_nb_context,_param->_nb_inst_fetch[it1],_param->_size_inst_ifetch_ptr );
        DELETE2_SIGNAL( in_IFETCH_BRANCH_STATE               ,_param->_nb_context,_param->_nb_inst_fetch[it1],_param->_size_branch_state    );
        DELETE2_SIGNAL( in_IFETCH_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_context,_param->_nb_inst_fetch[it1],_param->_size_depth           );
        DELETE2_SIGNAL( in_IFETCH_EXCEPTION                  ,_param->_nb_context,_param->_nb_inst_fetch[it1],_param->_size_exception_ifetch);

        DELETE1_SIGNAL(out_DECOD_VAL          ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_DECOD_ACK          ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL(out_DECOD_CONTEXT_ID   ,_param->_nb_inst_decod,_param->_size_context_id            );
        DELETE1_SIGNAL(out_DECOD_DEPTH        ,_param->_nb_inst_decod,_param->_size_depth                 );
#ifdef STATISTICS
        DELETE1_SIGNAL(out_DECOD_INSTRUCTION  ,_param->_nb_inst_decod,32                                  );
#endif
        DELETE1_SIGNAL(out_DECOD_TYPE         ,_param->_nb_inst_decod,_param->_size_type                  );
        DELETE1_SIGNAL(out_DECOD_OPERATION    ,_param->_nb_inst_decod,_param->_size_operation             );
        DELETE1_SIGNAL(out_DECOD_NO_EXECUTE   ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_IS_DELAY_SLOT,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_SAVE_RAT     ,_param->_nb_inst_decod,1                                   );
#ifdef DEBUG
        DELETE1_SIGNAL(out_DECOD_ADDRESS      ,_param->_nb_inst_decod,_param->_size_instruction_address   );
#endif
        DELETE1_SIGNAL(out_DECOD_ADDRESS_NEXT ,_param->_nb_inst_decod,_param->_size_instruction_address   );
        DELETE1_SIGNAL(out_DECOD_HAS_IMMEDIAT ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_IMMEDIAT     ,_param->_nb_inst_decod,_param->_size_general_data          );
        DELETE1_SIGNAL(out_DECOD_READ_RA      ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RA   ,_param->_nb_inst_decod,_param->_size_general_register_logic);
        DELETE1_SIGNAL(out_DECOD_READ_RB      ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RB   ,_param->_nb_inst_decod,_param->_size_general_register_logic);
        DELETE1_SIGNAL(out_DECOD_READ_RC      ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RC   ,_param->_nb_inst_decod,_param->_size_special_register_logic);
        DELETE1_SIGNAL(out_DECOD_WRITE_RD     ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RD   ,_param->_nb_inst_decod,_param->_size_general_register_logic);
        DELETE1_SIGNAL(out_DECOD_WRITE_RE     ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RE   ,_param->_nb_inst_decod,_param->_size_special_register_logic);
        DELETE1_SIGNAL(out_DECOD_EXCEPTION_USE,_param->_nb_inst_decod,_param->_size_exception_use         );
        DELETE1_SIGNAL(out_DECOD_EXCEPTION    ,_param->_nb_inst_decod,_param->_size_exception_decod       );

        DELETE1_SIGNAL(out_PREDICT_VAL                        ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_PREDICT_ACK                        ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL(out_PREDICT_CONTEXT_ID                 ,_param->_nb_inst_decod,_param->_size_context_id      );
        DELETE1_SIGNAL(out_PREDICT_MATCH_INST_IFETCH_PTR      ,_param->_nb_inst_decod,1                             );
        DELETE1_SIGNAL(out_PREDICT_BRANCH_STATE               ,_param->_nb_inst_decod,_param->_size_branch_state    );
        DELETE1_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_inst_decod,_param->_size_depth           );
        DELETE1_SIGNAL(out_PREDICT_BRANCH_CONDITION           ,_param->_nb_inst_decod,_param->_size_branch_condition);
//      DELETE1_SIGNAL(out_PREDICT_BRANCH_STACK_WRITE         ,_param->_nb_inst_decod,1                             );
        DELETE1_SIGNAL(out_PREDICT_BRANCH_DIRECTION           ,_param->_nb_inst_decod,1                             );
        DELETE1_SIGNAL(out_PREDICT_ADDRESS_SRC                ,_param->_nb_inst_decod,_param->_size_instruction_address    );
        DELETE1_SIGNAL(out_PREDICT_ADDRESS_DEST               ,_param->_nb_inst_decod,_param->_size_instruction_address    );
        DELETE1_SIGNAL( in_PREDICT_CAN_CONTINUE               ,_param->_nb_inst_decod,1                             );

        DELETE1_SIGNAL(in_CONTEXT_DECOD_ENABLE, _param->_nb_context,1);
        DELETE1_SIGNAL(in_CONTEXT_DEPTH_VAL   , _param->_nb_context,1);
        DELETE1_SIGNAL(in_CONTEXT_DEPTH       , _param->_nb_context,_param->_size_depth);

        DELETE0_SIGNAL(out_CONTEXT_EVENT_VAL          ,1);
        DELETE0_SIGNAL( in_CONTEXT_EVENT_ACK          ,1);
        DELETE0_SIGNAL(out_CONTEXT_EVENT_CONTEXT_ID   ,_param->_size_context_id  );
        DELETE0_SIGNAL(out_CONTEXT_EVENT_DEPTH        ,_param->_size_depth       );
        DELETE0_SIGNAL(out_CONTEXT_EVENT_TYPE         ,_param->_size_event_type  );
        DELETE0_SIGNAL(out_CONTEXT_EVENT_IS_DELAY_SLOT,1                         );
        DELETE0_SIGNAL(out_CONTEXT_EVENT_ADDRESS      ,_param->_size_instruction_address);
        DELETE0_SIGNAL(out_CONTEXT_EVENT_ADDRESS_EPCR ,_param->_size_instruction_address);


        DELETE1(reg_CONTEXT_ADDRESS_PREVIOUS      ,_param->_nb_context);
        DELETE1(reg_CONTEXT_IS_DELAY_SLOT         ,_param->_nb_context);
//      DELETE1(reg_CONTEXT_SAVE_RAT              ,_param->_nb_context);

        DELETE1(internal_CONTEXT_HAVE_TRANSACTION ,_param->_nb_context);
        DELETE1(internal_CONTEXT_ADDRESS_PREVIOUS ,_param->_nb_context);
        DELETE1(internal_CONTEXT_IS_DELAY_SLOT    ,_param->_nb_context);
//      DELETE1(internal_CONTEXT_SAVE_RAT         ,_param->_nb_context);

#ifdef STATISTICS
        DELETE1(internal_DECOD_VAL                ,_param->_nb_inst_decod);
#endif
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete    _priority;

    DELETE3(_function_decod   ,_param->_nb_context,nb_opcod_type,tab_opcod_type[it2]);
    DELETE3(_function_custom  ,_param->_nb_context,nb_opcod_type,tab_opcod_type[it2]);
    DELETE0(_decod_instruction);

    for (uint32_t i=0; i<_param->_nb_context; i++)
      delete _decod_param [i];
    DELETE1(_decod_param      ,_param->_nb_context);

    delete    _component;

    log_printf(FUNC,Decod,FUNCTION,"End");
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
