#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_ooo_engine_glue_OOO_Engine_Glue_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_ooo_engine_glue_OOO_Engine_Glue_h

/*
 * $Id: OOO_Engine_Glue.h 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/OOO_Engine_Glue/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/OOO_Engine_Glue/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace ooo_engine_glue {


  class OOO_Engine_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;

//private   : counter_t                      * _stat_nb_inst_issue_stall_by_registerfile;
//private   : counter_t                      * _stat_nb_inst_issue_stall_by_rename_unit ;
  private   : counter_t                      * _stat_nb_inst_issue_stall_by_commit_unit ;
  private   : counter_t                      * _stat_nb_inst_issue_stall_by_issue_queue ;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontext_t         ) ***  in_RENAME_FRONT_END_ID                          ;//[nb_front_end][nb_inst_decod]
  public    : SC_OUT(Tcontext_t         ) *** out_RENAME_RENAME_UNIT_FRONT_END_ID              ;//[nb_front_end][nb_inst_decod]

    // ~~~~~[ Interface : "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//   public    : SC_OUT(Tcontrol_t         )  ** out_INSERT_VAL                                   ;//[sum_inst_insert]
//   public    : SC_IN (Tcontrol_t         )  **  in_INSERT_ACK                                   ;//[sum_inst_insert]
//   public    : SC_OUT(Tcontrol_t         )  ** out_INSERT_RD_USE                                ;//[sum_inst_insert]
//   public    : SC_OUT(Tgeneral_address_t )  ** out_INSERT_RD_NUM_REG                            ;//[sum_inst_insert]
//   public    : SC_OUT(Tcontrol_t         )  ** out_INSERT_RE_USE                                ;//[sum_inst_insert]
//   public    : SC_OUT(Tspecial_address_t )  ** out_INSERT_RE_NUM_REG                            ;//[sum_inst_insert]

  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_RENAME_UNIT_VAL                       ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_RENAME_UNIT_ACK                       ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_RENAME_UNIT_NO_EXECUTE                ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontext_t         ) ***  in_INSERT_RENAME_UNIT_FRONT_END_ID              ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontext_t         ) ***  in_INSERT_RENAME_UNIT_CONTEXT_ID                ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Ttype_t            ) ***  in_INSERT_RENAME_UNIT_TYPE                      ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Toperation_t       ) ***  in_INSERT_RENAME_UNIT_OPERATION                 ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_RENAME_UNIT_HAS_IMMEDIAT              ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_data_t    ) ***  in_INSERT_RENAME_UNIT_IMMEDIAT                  ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tlsq_ptr_t         ) ***  in_INSERT_RENAME_UNIT_STORE_QUEUE_PTR_WRITE     ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tlsq_ptr_t         ) ***  in_INSERT_RENAME_UNIT_STORE_QUEUE_PTR_READ      ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_RENAME_UNIT_STORE_QUEUE_EMPTY         ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tlsq_ptr_t         ) ***  in_INSERT_RENAME_UNIT_LOAD_QUEUE_PTR_WRITE      ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_RENAME_UNIT_READ_RA                   ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t ) ***  in_INSERT_RENAME_UNIT_NUM_REG_RA_PHY            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_RENAME_UNIT_READ_RB                   ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t ) ***  in_INSERT_RENAME_UNIT_NUM_REG_RB_PHY            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_RENAME_UNIT_READ_RC                   ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tspecial_address_t ) ***  in_INSERT_RENAME_UNIT_NUM_REG_RC_PHY            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_RENAME_UNIT_WRITE_RD                  ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t ) ***  in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_OLD        ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t ) ***  in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_NEW        ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_RENAME_UNIT_WRITE_RE                  ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tspecial_address_t ) ***  in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_OLD        ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tspecial_address_t ) ***  in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_NEW        ;//[nb_rename_unit][nb_inst_insert]

  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_COMMIT_UNIT_VAL                       ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_COMMIT_UNIT_ACK                       ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontext_t         ) *** out_INSERT_COMMIT_UNIT_FRONT_END_ID              ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontext_t         ) *** out_INSERT_COMMIT_UNIT_CONTEXT_ID                ;//[nb_rename_unit][nb_inst_insert]
//public    : SC_OUT(Tcontext_t         ) *** out_INSERT_COMMIT_UNIT_RENAME_UNIT_ID            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Ttype_t            ) *** out_INSERT_COMMIT_UNIT_TYPE                      ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Toperation_t       ) *** out_INSERT_COMMIT_UNIT_OPERATION                 ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_COMMIT_UNIT_NO_EXECUTE                ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tlsq_ptr_t         ) *** out_INSERT_COMMIT_UNIT_STORE_QUEUE_PTR_WRITE     ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tlsq_ptr_t         ) *** out_INSERT_COMMIT_UNIT_LOAD_QUEUE_PTR_WRITE      ;//[nb_rename_unit][nb_inst_insert]
#ifdef DEBUG
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_COMMIT_UNIT_READ_RA                   ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t ) *** out_INSERT_COMMIT_UNIT_NUM_REG_RA_PHY            ;//[nb_rename_unit][nb_inst_insert]
#endif
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_COMMIT_UNIT_READ_RB                   ;//[nb_rename_unit][nb_inst_insert]
#ifdef DEBUG
  public    : SC_OUT(Tgeneral_address_t ) *** out_INSERT_COMMIT_UNIT_NUM_REG_RB_PHY            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_COMMIT_UNIT_READ_RC                   ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t ) *** out_INSERT_COMMIT_UNIT_NUM_REG_RC_PHY            ;//[nb_rename_unit][nb_inst_insert]
#endif
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_COMMIT_UNIT_WRITE_RD                  ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t ) *** out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_OLD        ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t ) *** out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_NEW        ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_COMMIT_UNIT_WRITE_RE                  ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t ) *** out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_OLD        ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t ) *** out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_NEW        ;//[nb_rename_unit][nb_inst_insert]

  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_ISSUE_QUEUE_VAL                       ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_ISSUE_QUEUE_ACK                       ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontext_t         ) *** out_INSERT_ISSUE_QUEUE_CONTEXT_ID                ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontext_t         ) *** out_INSERT_ISSUE_QUEUE_FRONT_END_ID              ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Toperation_t       ) *** out_INSERT_ISSUE_QUEUE_OPERATION                 ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Ttype_t            ) *** out_INSERT_ISSUE_QUEUE_TYPE                      ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tlsq_ptr_t         ) *** out_INSERT_ISSUE_QUEUE_STORE_QUEUE_PTR_WRITE     ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tlsq_ptr_t         ) *** out_INSERT_ISSUE_QUEUE_STORE_QUEUE_PTR_READ      ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_ISSUE_QUEUE_STORE_QUEUE_EMPTY         ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tlsq_ptr_t         ) *** out_INSERT_ISSUE_QUEUE_LOAD_QUEUE_PTR_WRITE      ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_ISSUE_QUEUE_HAS_IMMEDIAT              ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tgeneral_data_t    ) *** out_INSERT_ISSUE_QUEUE_IMMEDIAT                  ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_ISSUE_QUEUE_READ_RA                   ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t ) *** out_INSERT_ISSUE_QUEUE_NUM_REG_RA                ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_ISSUE_QUEUE_READ_RB                   ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t ) *** out_INSERT_ISSUE_QUEUE_NUM_REG_RB                ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_ISSUE_QUEUE_READ_RC                   ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t ) *** out_INSERT_ISSUE_QUEUE_NUM_REG_RC                ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_ISSUE_QUEUE_WRITE_RD                  ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t ) *** out_INSERT_ISSUE_QUEUE_NUM_REG_RD                ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_ISSUE_QUEUE_WRITE_RE                  ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t ) *** out_INSERT_ISSUE_QUEUE_NUM_REG_RE                ;//[nb_rename_unit][nb_inst_insert]

//     // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//   public    : SC_OUT(Tcontrol_t         )  ** out_RETIRE_VAL                                   ;//[sum_inst_retire]
//   public    : SC_IN (Tcontrol_t         )  **  in_RETIRE_ACK                                   ;//[sum_inst_retire]
//   public    : SC_OUT(Tcontrol_t         )  ** out_RETIRE_RD_OLD_USE                            ;//[sum_inst_retire] 
//   public    : SC_OUT(Tgeneral_address_t )  ** out_RETIRE_RD_OLD_NUM_REG                        ;//[sum_inst_retire]
//   public    : SC_OUT(Tcontrol_t         )  ** out_RETIRE_RD_NEW_USE                            ;//[sum_inst_retire]
//   public    : SC_OUT(Tgeneral_address_t )  ** out_RETIRE_RD_NEW_NUM_REG                        ;//[sum_inst_retire]
//   public    : SC_OUT(Tcontrol_t         )  ** out_RETIRE_RE_OLD_USE                            ;//[sum_inst_retire] 
//   public    : SC_OUT(Tspecial_address_t )  ** out_RETIRE_RE_OLD_NUM_REG                        ;//[sum_inst_retire]
//   public    : SC_OUT(Tcontrol_t         )  ** out_RETIRE_RE_NEW_USE                            ;//[sum_inst_retire]
//   public    : SC_OUT(Tspecial_address_t )  ** out_RETIRE_RE_NEW_NUM_REG                        ;//[sum_inst_retire]

//   public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_RENAME_UNIT_VAL                       ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_IN (Tcontrol_t         ) ***  in_RETIRE_RENAME_UNIT_ACK                       ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_OUT(Tcontext_t         ) *** out_RETIRE_RENAME_UNIT_FRONT_END_ID              ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_RENAME_UNIT_WRITE_RD                  ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_OUT(Tgeneral_address_t ) *** out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_OLD        ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_OUT(Tgeneral_address_t ) *** out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_NEW        ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_RENAME_UNIT_WRITE_RE                  ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_OUT(Tspecial_address_t ) *** out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_OLD        ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_OUT(Tspecial_address_t ) *** out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_NEW        ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_OUT(Tevent_state_t     ) *** out_RETIRE_RENAME_UNIT_EVENT_STATE               ;//[nb_rename_unit][nb_inst_retire]

//   public    : SC_IN (Tcontrol_t         ) ***  in_RETIRE_COMMIT_UNIT_VAL                       ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_COMMIT_UNIT_ACK                       ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_IN (Tcontext_t         ) ***  in_RETIRE_COMMIT_UNIT_FRONT_END_ID              ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_IN (Tcontrol_t         ) ***  in_RETIRE_COMMIT_UNIT_WRITE_RD                  ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_IN (Tgeneral_address_t ) ***  in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_OLD        ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_IN (Tgeneral_address_t ) ***  in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_NEW        ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_IN (Tcontrol_t         ) ***  in_RETIRE_COMMIT_UNIT_WRITE_RE                  ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_IN (Tspecial_address_t ) ***  in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_OLD        ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_IN (Tspecial_address_t ) ***  in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_NEW        ;//[nb_rename_unit][nb_inst_retire]
//   public    : SC_IN (Tevent_state_t     ) ***  in_RETIRE_COMMIT_UNIT_EVENT_STATE               ;//[nb_rename_unit][nb_inst_retire]

    // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         ) *** out_SPR_SR_IEE                                   ;//[nb_front_end][nb_context] - Interrupt Exception Enabled
  public    : SC_OUT(Tcontrol_t         ) *** out_SPR_SR_EPH                                   ;//[nb_front_end][nb_context] - Exception Prefix High
  public    : SC_OUT(Tspr_t             ) *** out_SPR_RENAME_UNIT_SR                           ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t         ) *** out_SPR_COMMIT_UNIT_SR_OVE                       ;//[nb_front_end][nb_context]
  public    : SC_IN (Tspr_t             ) ***  in_SPR_SPECIAL_REGISTER_UNIT_SR                 ;//[nb_front_end][nb_context]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (OOO_Engine_Glue);
#endif
  public  :          OOO_Engine_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~OOO_Engine_Glue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
//public  : void        genMoore                  (void);
  public  : void        genMealy_rename           (void);
  public  : void        genMealy_insert_valack    (void);
  public  : void        genMealy_insert           (void);
  public  : void        genMealy_retire_valack    (void);
  public  : void        genMealy_retire           (void);
  public  : void        genMealy_spr              (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace ooo_engine_glue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
