/*
 * $Id: Rename_unit.cpp 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/include/Rename_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {


#undef  FUNCTION
#define FUNCTION "Rename_unit::Rename_unit"
  Rename_unit::Rename_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Rename_unit,FUNCTION);

    usage_environment(_usage);

// #if DEBUG_Rename_unit == true
//     log_printf(INFO,Rename_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Rename_unit,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Rename_unit,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Rename_unit,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#if defined(SYSTEMC) and (defined(STATISTICS) or defined(VHDL_TESTBENCH))
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Rename_unit,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
      }
#endif
    log_end(Rename_unit,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Rename_unit::~Rename_unit"
  Rename_unit::~Rename_unit (void)
  {
    log_begin(Rename_unit,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Rename_unit,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Rename_unit,FUNCTION);
  };

}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
