/*
 * $Id: Multiplier_deallocation.cpp 116 2009-04-30 13:51:41Z moulu $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Multiplier/include/Multiplier.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace multiplier {


#undef  FUNCTION
#define FUNCTION "Multiplier::deallocation"
  void Multiplier::deallocation (void)
  {
    log_begin(Multiplier,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE0_SIGNAL(in_MULTIPLIER_DATA_IN_0,_param->_size_data);
        DELETE0_SIGNAL(in_MULTIPLIER_DATA_IN_1,_param->_size_data);
        DELETE0_SIGNAL(in_MULTIPLIER_NSTALL   ,1);
                                              
        DELETE0_SIGNAL(out_MULTIPLIER_DATA_LSB_OUT,_param->_size_data);
        DELETE0_SIGNAL(out_MULTIPLIER_DATA_MSB_OUT,_param->_size_data);

      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC_BODY))
      {
        delete _pipeline;
      }
#endif

    delete _component;

    log_end(Multiplier,FUNCTION);
  };

}; // end namespace multiplier
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
