#ifndef Morpheo_Behavioural_Operation_h
#define Morpheo_Behavioural_Operation_h

/*
 * $Id: Operation.h 141 2010-08-02 18:56:05Z rosiere $
 *
 * [ Description ]
 * 
 */

namespace morpheo {
namespace behavioural {

#  define neg(     size,data)           (~(data)+1)
#  define sign(    size,data)           ((data)>>(size-1))
#  define unsigned(size,data)           (data)
#  define signed(  size,data)           ((sign(size,data)==0)?(data):neg(size,data))
//#define ovf(     size,op1, op2, c_in) ((op2^(op1+op2+c_in))&~(op1^op2))>>(size-1);
#  define ovf(     size,op1, op2, res)  ((sign(size,op1) == sign(size,op2))?(sign(size,op1) xor sign(size,res)):0)
#  define carry(   size,op1, op2, res)  (((res)<(op1)) or ((res)<(op2)))
#  define set_flag(data,flag,is_set)    (((is_set)==1)?((data)|(flag)):((data)&~(flag)))
#  define get_flag(data,flag)	        (((data)&(flag))!=0)
#  define concatenation_bool(a,b)       (((a)<<1) | (b))

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
