/*
 * $Id: sc_main.cpp 142 2010-08-04 20:09:03Z rosiere $
 *
 * [ Description ]
 * 
 * Platforms : Morpheo + Environment
 */

#include "../include/test.h"

using namespace std;
using namespace morpheo;

void usage (int argc
#ifdef MTI_SYSTEMC
            ,const char * const * argv
#else
            ,char * argv[]
#endif
            )
{
  msgError("<Usage> %s\n",argv[0]);
  msgError("In input stream :\n");
  msgError(" * filename_simulator   (string  )\n");
  msgError(" * filename_generator   (string  )\n");
  msgError(" * filename_instance    (string  )\n");
  msgError(" * filename_software    (string  )\n");
  msgError(" * nb_cache_dedicated   (uint32_t)\n");
  msgError(" * nb_cache_shared      (uint32_t)\n");
  msgError(" * size cache L1 (byte) (uint32_t)\n");
  msgError(" * ratio cache          (uint32_t)\n");

  exit (EXIT_FAILURE);
};

#ifdef MTI_SYSTEMC
SC_MODULE_EXPORT(top);

top::top (sc_module_name name)
#else
int sc_main (int argc, char * argv[])
#endif
{
  msgInformation("<sc_main> Begin\n");

  sc_report_handler::set_actions("/IEEE_Std_1666/deprecated", SC_DO_NOTHING);

#ifdef MTI_SYSTEMC
  // accessing command-line arguments with modelsim
  int argc;
  const char * const * argv;

  argc = sc_argc ();
  argv = sc_argv ();
#endif

  msgInformation(" ");
  for (int32_t i=0; i<argc; ++i)
    msg("%s ",argv[i]);
  msg("\n");
  
  //==============================================================================
  //===== [ Parameters ]==========================================================
  //==============================================================================
  
  if (argc != 9)
    usage (argc, argv);
  
  uint32_t x = 1;
  string   filename_simulator = argv[x++];
  string   filename_generator = argv[x++];
  string   filename_instance  = argv[x++];
  string   filename_software  = argv[x++];
  uint32_t nb_cache_dedicated = fromString<uint32_t>(argv[x++]);
  uint32_t nb_cache_shared    = fromString<uint32_t>(argv[x++]);
  uint32_t cache_size         = fromString<uint32_t>(argv[x++]);
  uint32_t cache_ratio        = fromString<uint32_t>(argv[x++]);

  morpheo::behavioural::custom::custom_information_t (*get_custom_information) (void) = NULL;

  int _return = test (filename_simulator ,
                      filename_generator ,
                      filename_instance  ,
                      filename_software  ,
                      nb_cache_dedicated ,
                      nb_cache_shared    ,
                      cache_size         ,
                      cache_ratio        ,
                      get_custom_information);

  msgInformation("  * return : %d\n",_return);
  msgInformation("<sc_main> End\n");

#ifndef MTI_SYSTEMC
  return _return;
#endif
};
