#ifdef SYSTEMC
/*
 * $Id: Core_Glue_genMealy_issue.cpp 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {

  /*
      OOO     Execute Loop                                  
    ---+          +-----
       |  +-----+ |     
      -+->|     |-+->   
       |  |     | |     
      -+->|     |-+->   
       |  |     | |     
      -+->|     | +-----
       |  |     |       
      -+->|     | +-----
       |  |     | |     
    ---+  | _ _ |-+->   
          | _X_ | |     
    ---+  |     |-+->   
       |  |     | |     
      -+->|     | +-----
       |  |     |       
      -+->|     | +-----
       |  |     | |     
      -+->|     |-+->   
       |  |     | |     
      -+->|     |-+->   
       |  +-----+ |     
    ---+ dispatch +-----
  */


// class num_read_unit_t
//   {
//   public : const uint32_t num_execute_loop;
//   public : const uint32_t num_read_unit;
    
//   public : num_read_unit_t (uint32_t num_execute_loop,
//                             uint32_t num_read_unit) :
//     this->num_execute_loop (num_execute_loop),
//     this->num_read_unit    (num_read_unit   )
//     {};
//   }

#undef  FUNCTION
#define FUNCTION "Core_Glue::genMealy_issue"
  void Core_Glue::genMealy_issue (void)
  {
    log_begin(Core_Glue,FUNCTION);
    log_function(Core_Glue,FUNCTION,_name.c_str());

    Tcontrol_t ISSUE_OOO_ENGINE_ACK   [_param->_nb_ooo_engine  ][_param->_max_nb_inst_issue_queue];
    Tcontrol_t ISSUE_EXECUTE_LOOP_VAL [_param->_nb_execute_loop][_param->_max_nb_read_unit];

    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_nb_inst_issue_queue[i]; ++j)
        ISSUE_OOO_ENGINE_ACK [i][j] = 0;
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
        ISSUE_EXECUTE_LOOP_VAL [i][j] = 0;
    
    if (PORT_READ(in_NRESET))
      {
    Tcontrol_t READ_UNIT_ENABLE       [_param->_nb_execute_loop][_param->_max_nb_read_unit];
    
    // Init -> all at 0
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
        {
          // Read unit is enable is signal ack is set
          READ_UNIT_ENABLE       [i][j] = (PORT_READ(in_ISSUE_EXECUTE_LOOP_ACK [i][j]) == 1);
	  log_printf(TRACE,Core_Glue,FUNCTION,"  * Read_unit [%d][%d].enable : %d",i,j,READ_UNIT_ENABLE[i][j]);
        }

    std::list<generic::priority::select_t> * select_ooo_engine = _priority_ooo_engine->select();
    for (std::list<generic::priority::select_t>::iterator it_ooo_engine=select_ooo_engine->begin();
         it_ooo_engine!=select_ooo_engine->end();
         ++it_ooo_engine)
      {
        // select the most priotary 
        uint32_t num_ooo_engine = it_ooo_engine->grp;

        for (uint32_t num_inst_issue_queue=0; num_inst_issue_queue<_param->_nb_inst_issue_queue[num_ooo_engine]; ++num_inst_issue_queue)
          {
            // init stop condition
            bool find = false;
            
            // Read request information from issue_queue
            Tcontrol_t val          = PORT_READ(in_ISSUE_OOO_ENGINE_VAL  [num_ooo_engine][num_inst_issue_queue]);
            Ttype_t    type         = PORT_READ(in_ISSUE_OOO_ENGINE_TYPE [num_ooo_engine][num_inst_issue_queue]);
            Tcontext_t context_id   = (_param->_have_port_context_id  )?PORT_READ(in_ISSUE_OOO_ENGINE_CONTEXT_ID   [num_ooo_engine][num_inst_issue_queue]):0;
            Tcontext_t front_end_id = (_param->_have_port_front_end_id)?PORT_READ(in_ISSUE_OOO_ENGINE_FRONT_END_ID [num_ooo_engine][num_inst_issue_queue]):0;
            uint32_t   num_thread    = _param->_translate_num_context_to_num_thread[num_ooo_engine][front_end_id][context_id];
            
            log_printf(TRACE,Core_Glue,FUNCTION,"  * num_ooo_engine                : %d",num_ooo_engine      );
            log_printf(TRACE,Core_Glue,FUNCTION,"  * num_inst_issue_queue          : %d",num_inst_issue_queue);
            log_printf(TRACE,Core_Glue,FUNCTION,"    * val                         : %d",val);
            log_printf(TRACE,Core_Glue,FUNCTION,"    * type                        : %d",type);  
            log_printf(TRACE,Core_Glue,FUNCTION,"    * context_id                  : %d",context_id);
            log_printf(TRACE,Core_Glue,FUNCTION,"    * front_end_id                : %d",front_end_id);
            log_printf(TRACE,Core_Glue,FUNCTION,"    * num_thread                  : %d",num_thread);
          
            if (val)
              // for each execute_loop
              for (uint32_t num_execute_loop=0; num_execute_loop<_param->_nb_execute_loop; ++num_execute_loop)
                {
                  // for each read_unit
                  std::list<generic::priority::select_t> * select_read_unit = _priority_read_unit[num_execute_loop]->select();
                  for (std::list<generic::priority::select_t>::iterator it_read_unit=select_read_unit->begin();
                       it_read_unit!=select_read_unit->end();
                       ++it_read_unit)
                    {
                      // get the most priotary ...
                      uint32_t num_read_unit = it_read_unit->grp;
                      Tcontrol_t ack = READ_UNIT_ENABLE [num_execute_loop][num_read_unit];
                      
                      log_printf(TRACE,Core_Glue,FUNCTION,"      * num_execute_loop          : %d",num_execute_loop);
                      log_printf(TRACE,Core_Glue,FUNCTION,"      * num_read_unit             : %d",num_read_unit   );
                      log_printf(TRACE,Core_Glue,FUNCTION,"        * read_unit_enable        : %d",ack             );
                      
                      // test if :
                      //  * read_unit can accept an instruction (valid and no previous instruction)
                      //  * read_unit can accept this type
                      if (ack and
                          _param->_table_issue_type   [num_execute_loop][num_read_unit][type] and
                          _param->_table_issue_thread [num_execute_loop][num_read_unit][num_thread])
                        {
                          log_printf(TRACE,Core_Glue,FUNCTION,"  * find !!!");
                          
                          // find !
                          // Transaction
                          find = true;

                          READ_UNIT_ENABLE       [num_execute_loop][num_read_unit] = false; // now, this read_unit is busy
                          ISSUE_EXECUTE_LOOP_VAL [num_execute_loop][num_read_unit] = 1; // = val
                          ISSUE_OOO_ENGINE_ACK   [num_ooo_engine][num_inst_issue_queue] = 1; // = ack
                          
                          if (_param->_have_port_context_id)
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_CONTEXT_ID            [num_execute_loop][num_read_unit],context_id);
                          if (_param->_have_port_front_end_id)
			  PORT_WRITE(out_ISSUE_EXECUTE_LOOP_FRONT_END_ID          [num_execute_loop][num_read_unit],front_end_id);
                          if (_param->_have_port_ooo_engine_id)
                            {
                          Tcontext_t ooo_engine_id = _param->_translate_num_ooo_engine_to_execute_loop_ooo_engine_id [num_ooo_engine][num_execute_loop];
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID         [num_execute_loop][num_read_unit],ooo_engine_id);
                            }
                          if (_param->_have_port_rob_ptr)
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_PACKET_ID             [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_PACKET_ID             [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_OPERATION             [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_OPERATION             [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_TYPE                  [num_execute_loop][num_read_unit],type);
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_CANCEL                [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_CANCEL                [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_READ  [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_READ  [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_EMPTY     [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_STORE_QUEUE_EMPTY     [num_ooo_engine][num_inst_issue_queue]));
                          if (_param->_have_port_load_queue_ptr)
			  PORT_WRITE(out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE  [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE  [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT          [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT          [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_IMMEDIAT              [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_IMMEDIAT              [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RA               [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RA               [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RA            [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RA            [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RB               [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RB               [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RB            [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RB            [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RC               [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RC               [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RC            [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RC            [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_WRITE_RD              [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_WRITE_RD              [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RD            [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RD            [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_WRITE_RE              [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_WRITE_RE              [num_ooo_engine][num_inst_issue_queue]));
                          PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RE            [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RE            [num_ooo_engine][num_inst_issue_queue]));
                          break;
                        }
                      //if (find)
                      //  break;
                    }
                  if (find)
                    break;
                }
            
            if (_param->_issue_queue_in_order [num_ooo_engine] and
                not find and 
                (num_inst_issue_queue >= _param->_nb_inst_reexecute [num_ooo_engine]))
              {
                log_printf(TRACE,Core_Glue,FUNCTION,"  * stop scan !!!");
                
                break; // stop scan
              }
          }
      }
    
      }

    // Write output
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_nb_inst_issue_queue[i]; ++j)
        PORT_WRITE(out_ISSUE_OOO_ENGINE_ACK [i][j], ISSUE_OOO_ENGINE_ACK [i][j]);
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_VAL [i][j], ISSUE_EXECUTE_LOOP_VAL [i][j]);

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
