/*
 * $Id: top_allocation.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/SelfTest/include/top.h"
#include "Behavioural/include/Allocation.h"
#include "Behavioural/include/Simulation.h"

void top::allocation (void)
{
  if (setlocale (LC_ALL, "") == NULL)
    msgWarning(_("setlocale ko.\n"));

  try 
    {
      _param->test();
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msgError(_("<%s> : %s"),name.c_str(),error.what());
      return;
    }
  catch (...)
    {
      msgError(_("<%s> : This test must generate a error"),name.c_str());
      exit (EXIT_FAILURE);
    }

  _usage = USE_ALL;
//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  _model.set_model("Write_unit"   ,MODEL_SYSTEMC, DEBUG_NONE);
  _model.set_model("Write_queue"  ,MODEL_SYSTEMC, DEBUG_NONE);
  _model.set_model("Execute_queue",MODEL_VHDL   , DEBUG_NONE);
  _model.print();

#ifdef STATISTICS
  if (usage_is_set(_usage,USE_STATISTICS))
  _param_stat = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  try 
    {
      component = new Write_unit 
        (name.c_str(),
#ifdef STATISTICS
         _param_stat,
#endif
         _param,
         _usage
         );
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msgError(_("<%s> : %s"),name.c_str(),error.what());
      throw error;
    }
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  msgInformation(_("<%s> : Create signal.\n"),name.c_str());

  in_CLOCK  = new sc_clock ("clock", TIME_PERIOD, TIME_UNIT, 0.5); //name,period,time_unit,duty_cycle

  ALLOC0_SC_SIGNAL( in_NRESET        ," in_NRESET        ",Tcontrol_t);

  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_VAL           ," in_WRITE_UNIT_IN_VAL"           , Tcontrol_t        );
  ALLOC0_SC_SIGNAL(out_WRITE_UNIT_IN_ACK           ,"out_WRITE_UNIT_IN_ACK"           , Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_CONTEXT_ID    ," in_WRITE_UNIT_IN_CONTEXT_ID"    , Tcontext_t        );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_FRONT_END_ID  ," in_WRITE_UNIT_IN_FRONT_END_ID"  , Tcontext_t        );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_OOO_ENGINE_ID ," in_WRITE_UNIT_IN_OOO_ENGINE_ID" , Tcontext_t        );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_PACKET_ID     ," in_WRITE_UNIT_IN_PACKET_ID"     , Tpacket_t         );
//ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_OPERATION     ," in_WRITE_UNIT_IN_OPERATION"     , Toperation_t      );
//ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_TYPE          ," in_WRITE_UNIT_IN_TYPE"          , Ttype_t           );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_WRITE_RD      ," in_WRITE_UNIT_IN_WRITE_RD"      , Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_NUM_REG_RD    ," in_WRITE_UNIT_IN_NUM_REG_RD"    , Tgeneral_address_t);
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_DATA_RD       ," in_WRITE_UNIT_IN_DATA_RD"       , Tgeneral_data_t   );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_WRITE_RE      ," in_WRITE_UNIT_IN_WRITE_RE"      , Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_NUM_REG_RE    ," in_WRITE_UNIT_IN_NUM_REG_RE"    , Tspecial_address_t);
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_DATA_RE       ," in_WRITE_UNIT_IN_DATA_RE"       , Tspecial_data_t   );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_EXCEPTION     ," in_WRITE_UNIT_IN_EXCEPTION"     , Texception_t      );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_NO_SEQUENCE   ," in_WRITE_UNIT_IN_NO_SEQUENCE"   , Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_IN_ADDRESS       ," in_WRITE_UNIT_IN_ADDRESS"       , Taddress_t        );
  ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_VAL          ,"out_WRITE_UNIT_OUT_VAL"          , Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_WRITE_UNIT_OUT_ACK          ," in_WRITE_UNIT_OUT_ACK"          , Tcontrol_t        );
  ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_CONTEXT_ID   ,"out_WRITE_UNIT_OUT_CONTEXT_ID"   , Tcontext_t        );
  ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_FRONT_END_ID ,"out_WRITE_UNIT_OUT_FRONT_END_ID" , Tcontext_t        );
  ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_OOO_ENGINE_ID,"out_WRITE_UNIT_OUT_OOO_ENGINE_ID", Tcontext_t        );
  ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_PACKET_ID    ,"out_WRITE_UNIT_OUT_PACKET_ID"    , Tpacket_t         );
//ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_OPERATION    ,"out_WRITE_UNIT_OUT_OPERATION"    , Toperation_t      );
//ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_TYPE         ,"out_WRITE_UNIT_OUT_TYPE"         , Ttype_t           );
  ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_FLAGS        ,"out_WRITE_UNIT_OUT_FLAGS"        , Tspecial_data_t   );
  ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_EXCEPTION    ,"out_WRITE_UNIT_OUT_EXCEPTION"    , Texception_t      );
  ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_NO_SEQUENCE  ,"out_WRITE_UNIT_OUT_NO_SEQUENCE"  , Tcontrol_t        );
  ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_ADDRESS      ,"out_WRITE_UNIT_OUT_ADDRESS"      , Taddress_t        );
  ALLOC0_SC_SIGNAL(out_WRITE_UNIT_OUT_DATA         ,"out_WRITE_UNIT_OUT_DATA"         , Tgeneral_data_t   );
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_VAL                ,"out_GPR_WRITE_VAL"                , Tcontrol_t        , _param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_ACK                ," in_GPR_WRITE_ACK"                , Tcontrol_t        , _param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_OOO_ENGINE_ID      ,"out_GPR_WRITE_OOO_ENGINE_ID"      , Tcontext_t        , _param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_NUM_REG            ,"out_GPR_WRITE_NUM_REG"            , Tgeneral_address_t, _param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_DATA               ,"out_GPR_WRITE_DATA"               , Tgeneral_data_t   , _param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_VAL                ,"out_SPR_WRITE_VAL"                , Tcontrol_t        , _param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_ACK                ," in_SPR_WRITE_ACK"                , Tcontrol_t        , _param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_OOO_ENGINE_ID      ,"out_SPR_WRITE_OOO_ENGINE_ID"      , Tcontext_t        , _param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_NUM_REG            ,"out_SPR_WRITE_NUM_REG"            , Tspecial_address_t, _param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_DATA               ,"out_SPR_WRITE_DATA"               , Tspecial_data_t   , _param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_BYPASS_WRITE_OOO_ENGINE_ID   ,"out_BYPASS_WRITE_OOO_ENGINE_ID"   , Tcontext_t        , _param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL(out_BYPASS_WRITE_GPR_VAL         ,"out_BYPASS_WRITE_GPR_VAL"         , Tcontrol_t        , _param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL(out_BYPASS_WRITE_GPR_NUM_REG     ,"out_BYPASS_WRITE_GPR_NUM_REG"     , Tgeneral_address_t, _param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL(out_BYPASS_WRITE_GPR_DATA        ,"out_BYPASS_WRITE_GPR_DATA"        , Tgeneral_data_t   , _param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL(out_BYPASS_WRITE_SPR_VAL         ,"out_BYPASS_WRITE_SPR_VAL"         , Tcontrol_t        , _param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL(out_BYPASS_WRITE_SPR_NUM_REG     ,"out_BYPASS_WRITE_SPR_NUM_REG"     , Tspecial_address_t, _param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL(out_BYPASS_WRITE_SPR_DATA        ,"out_BYPASS_WRITE_SPR_DATA"        , Tspecial_data_t   , _param->_nb_bypass_write);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msgInformation(_("<%s> : Instanciation of _Write_unit.\n"),name.c_str());

  INSTANCE0_SC_SIGNAL(component, in_CLOCK         );
  INSTANCE0_SC_SIGNAL(component, in_NRESET        );

  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_VAL           );
  INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_IN_ACK           );
  if (_param->_have_port_context_id)
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_CONTEXT_ID    );
  if (_param->_have_port_front_end_id)
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_FRONT_END_ID  );
  if (_param->_have_port_ooo_engine_id)
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_OOO_ENGINE_ID );
  if (_param->_have_port_rob_ptr)
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_PACKET_ID     );
//INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_OPERATION     );
//INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_TYPE          );
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_WRITE_RD      );
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_NUM_REG_RD    );
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_DATA_RD       );
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_WRITE_RE      );
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_NUM_REG_RE    );
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_DATA_RE       );
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_EXCEPTION     );
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_NO_SEQUENCE   );
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_IN_ADDRESS       );
  INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_VAL          );
  INSTANCE0_SC_SIGNAL(component,  in_WRITE_UNIT_OUT_ACK          );
  if (_param->_have_port_context_id)
  INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_CONTEXT_ID   );
  if (_param->_have_port_front_end_id)
  INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_FRONT_END_ID );
  if (_param->_have_port_ooo_engine_id)
  INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_OOO_ENGINE_ID);
  if (_param->_have_port_rob_ptr)
  INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_PACKET_ID    );
//INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_OPERATION    );
//INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_TYPE         );
  INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_FLAGS        );
  INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_EXCEPTION    );
  INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_NO_SEQUENCE  );
  INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_ADDRESS      );
  INSTANCE0_SC_SIGNAL(component, out_WRITE_UNIT_OUT_DATA         );
  INSTANCE1_SC_SIGNAL(component, out_GPR_WRITE_VAL                , _param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(component,  in_GPR_WRITE_ACK                , _param->_nb_gpr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(component, out_GPR_WRITE_OOO_ENGINE_ID      , _param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(component, out_GPR_WRITE_NUM_REG            , _param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(component, out_GPR_WRITE_DATA               , _param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(component, out_SPR_WRITE_VAL                , _param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(component,  in_SPR_WRITE_ACK                , _param->_nb_spr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(component, out_SPR_WRITE_OOO_ENGINE_ID      , _param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(component, out_SPR_WRITE_NUM_REG            , _param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(component, out_SPR_WRITE_DATA               , _param->_nb_spr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(component, out_BYPASS_WRITE_OOO_ENGINE_ID   , _param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(component, out_BYPASS_WRITE_GPR_VAL         , _param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(component, out_BYPASS_WRITE_GPR_NUM_REG     , _param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(component, out_BYPASS_WRITE_GPR_DATA        , _param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(component, out_BYPASS_WRITE_SPR_VAL         , _param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(component, out_BYPASS_WRITE_SPR_NUM_REG     , _param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(component, out_BYPASS_WRITE_SPR_DATA        , _param->_nb_bypass_write);
    }
#endif
}
