#ifdef STATISTICS
/*
 * $Id: Commit_unit_statistics_allocation.cpp 142 2010-08-04 20:09:03Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Commit_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace commit_unit {


#undef  FUNCTION
#define FUNCTION "Commit_unit::statistics_allocation"
  void Commit_unit::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_begin(Commit_unit,FUNCTION);

    _stat = new Stat (static_cast<std::string>(_name),
		      "Commit_unit",
		      param_statistics);

    _stat_nb_cycle_state_no_event      = new counter_t * [_param->_nb_thread];
    _stat_nb_cycle_state_not_yet_event = new counter_t * [_param->_nb_thread];
    _stat_nb_cycle_state_event         = new counter_t * [_param->_nb_thread];
    _stat_nb_cycle_state_wait_end      = new counter_t * [_param->_nb_thread];

    {
      for (uint32_t i=0; i<_param->_nb_thread; i++)
        if (_param->_have_thread [i])
          {
            _stat_nb_cycle_state_no_event      [i] = _stat->create_variable("nb_cycle_state_no_event_"     +toString(i));
            _stat_nb_cycle_state_not_yet_event [i] = _stat->create_variable("nb_cycle_state_not_yet_event_"+toString(i));
            _stat_nb_cycle_state_event         [i] = _stat->create_variable("nb_cycle_state_event_"        +toString(i));
            _stat_nb_cycle_state_wait_end      [i] = _stat->create_variable("nb_cycle_state_wait_end_"     +toString(i));
            
            _stat->create_expr_percent("percent_state_no_event_"      +toString(i),"nb_cycle_state_no_event_"      +toString(i),"cycle",toString(_("Percent of cycle in state no_event        (context %d)"),i));
            _stat->create_expr_percent("percent_state_not_yet_event_" +toString(i),"nb_cycle_state_not_yet_event_" +toString(i),"cycle",toString(_("Percent of cycle in state not_yet_event   (context %d)"),i));
            _stat->create_expr_percent("percent_state_event_"         +toString(i),"nb_cycle_state_event_"         +toString(i),"cycle",toString(_("Percent of cycle in state event           (context %d)"),i));
            _stat->create_expr_percent("percent_state_wait_end_"      +toString(i),"nb_cycle_state_wait_end_"      +toString(i),"cycle",toString(_("Percent of cycle in state wait_end        (context %d)"),i));
          }
    }

    _stat_nb_inst_retire_ok      = new counter_t * [_param->_nb_thread];
    _stat_nb_inst_retire_ko      = new counter_t * [_param->_nb_thread];
    _stat_nb_inst_instruction    = new counter_t * [NB_INSTRUCTION];
    _stat_nb_inst_type           = new counter_t * [_param->_nb_type];
    _stat_bank_nb_inst           = new counter_t * [_param->_nb_bank];

    {
      std::string sum_nb_inst_retire_ok = "0";
      std::string sum_nb_inst_retire_ko = "0";
      std::string sum_average;
      for (uint32_t i=0; i<_param->_nb_thread; i++)
        if (_param->_have_thread [i])
          {
            _stat_nb_inst_retire_ok [i] = _stat->create_variable("nb_inst_retire_ok_"+toString(i));
            _stat_nb_inst_retire_ko [i] = _stat->create_variable("nb_inst_retire_ko_"+toString(i));
            
            sum_nb_inst_retire_ok = "+ nb_inst_retire_ok_"+toString(i) + " " +sum_nb_inst_retire_ok;
            sum_nb_inst_retire_ko = "+ nb_inst_retire_ko_"+toString(i) + " " +sum_nb_inst_retire_ko;
            sum_average           = "+ average_inst_retire_ok_"+toString(i)+" average_inst_retire_ko_"+toString(i);
                        
            _stat->create_expr_average_by_cycle("average_inst_retire_ok_"+toString(i),"nb_inst_retire_ok_"+toString(i), "", toString(_("Average instruction retire ok by cycle (thread %d)"),i));
            _stat->create_expr_average_by_cycle("average_inst_retire_ko_"+toString(i),"nb_inst_retire_ko_"+toString(i), "", toString(_("Average instruction retire ko (event, miss) by cycle (thread %d)"),i));
            
            _stat->create_expr_percent         ("percent_inst_retire_ok_"+toString(i),"average_inst_retire_ok_"+toString(i), sum_average, toString(_("Percent instruction retire ok by cycle (thread %d)"),i));
            _stat->create_expr_percent         ("percent_inst_retire_ko_"+toString(i),"average_inst_retire_ko_"+toString(i), sum_average, toString(_("Percent instruction retire ko by cycle (thread %d)"),i));

            _stat->create_expr                 ("IPC_ok_"+toString(i) , "average_inst_retire_ok_"+toString(i), TYPE_COUNTER, "inst/cycle", toString("Instruction Per Cycle (Instruction Ok) (thread %d)",i));
            _stat->create_expr                 ("CPI_ok_"+toString(i) , "/ 1 IPC_ok_"+toString(i)            , TYPE_COUNTER, "cycle/inst", toString("Cycle Per Instruction (Instruction Ok) (thread %d)",i));
            
            _stat->create_expr                 ("IPC_ko_"+toString(i) , "average_inst_retire_ko_"+toString(i), TYPE_COUNTER, "inst/cycle", toString("Instruction Per Cycle (Instruction Ko) (thread %d)",i));
            _stat->create_expr                 ("CPI_ko_"+toString(i) , "/ 1 IPC_ko_"+toString(i)            , TYPE_COUNTER, "cycle/inst", toString("Cycle Per Instruction (Instruction Ko) (thread %d)",i));
            
            _stat->create_expr                 ("IPC_all_"+toString(i), "+ IPC_ok_"+toString(i)+" IPC_ko_"+toString(i), TYPE_COUNTER, "inst/cycle", toString("Instruction Per Cycle (Instruction Ok and Ko) (thread %d)",i));
            _stat->create_expr                 ("CPI_all_"+toString(i), "/ 1 IPC_all_"+toString(i)           , TYPE_COUNTER, "cycle/inst", toString("Cycle Per Instruction (Instruction Ok and Ko) (thread %d)",i));
          }

      _stat->create_expr_average_by_cycle("average_inst_retire_ok", sum_nb_inst_retire_ok, "", _("Average instruction retire ok by cycle (all thread)"));
      _stat->create_expr_average_by_cycle("average_inst_retire_ko", sum_nb_inst_retire_ko, "", _("Average instruction retire ko (event, miss) by cycle (all thread)"));
      
      sum_average = "+ average_inst_retire_ok average_inst_retire_ko";

      _stat->create_expr_percent         ("percent_inst_retire_ok","average_inst_retire_ok", sum_average, _("Percent instruction retire ok by cycle (all thread)"));
      _stat->create_expr_percent         ("percent_inst_retire_ko","average_inst_retire_ko", sum_average, _("Percent instruction retire ko by cycle (all thread)"));
            
      _stat->create_expr                 ("IPC_ok" , "/ "+sum_nb_inst_retire_ok+" cycle", TYPE_COUNTER, "inst/cycle", "Instruction Per Cycle (Instruction Ok)");
      _stat->create_expr                 ("CPI_ok" , "/ 1 IPC_ok"            , TYPE_COUNTER, "cycle/inst", "Cycle Per Instruction (Instruction Ok)");

      _stat->create_expr                 ("IPC_ko" , "/ "+sum_nb_inst_retire_ko+" cycle", TYPE_COUNTER, "inst/cycle", "Instruction Per Cycle (Instruction Ko)");
      _stat->create_expr                 ("CPI_ko" , "/ 1 IPC_ko"            , TYPE_COUNTER, "cycle/inst", "Cycle Per Instruction (Instruction Ko)");

      _stat->create_expr                 ("IPC_all", "+ IPC_ok IPC_ko"       , TYPE_COUNTER, "inst/cycle", "Instruction Per Cycle (Instruction Ok and Ko)");
      _stat->create_expr                 ("CPI_all", "/ 1 IPC_all"           , TYPE_COUNTER, "cycle/inst", "Cycle Per Instruction (Instruction Ok and Ko)");
    }

    {
      std::string sum_nb_inst_type = "0";

      for (uint32_t i=0; i<_param->_nb_type; i++)
	if (is_type_valid(i))
          {
            _stat_nb_inst_type [i] = _stat->create_variable("nb_inst_type_"+toString(i));
            
            sum_nb_inst_type = "+ nb_inst_type_"+toString(i) + " " +sum_nb_inst_type;
          }
 
      for (uint32_t i=0; i<_param->_nb_type; i++)
        if (is_type_valid(i))
          {
            std::string name = toString(static_cast<type_t>(i));

            _stat->create_expr_percent         ("percent_type_"+toString(name), "nb_inst_type_"+toString(i), sum_nb_inst_type, toString(_("Percent instruction retire ok by cycle (type %s)"),name.c_str()));
          }
    }

    {
      std::string sum_nb_inst_instruction = "0";

      for (uint32_t i=0; i<NB_INSTRUCTION; i++)
	{
	  _stat_nb_inst_instruction [i] = _stat->create_variable("nb_inst_instruction_"+toString(i));
          
	  sum_nb_inst_instruction = "+ nb_inst_instruction_"+toString(i) + " " +sum_nb_inst_instruction;
	}
 
      for (uint32_t i=0; i<NB_INSTRUCTION; i++)
	{
 	  std::string name = toString_instruction(i).c_str();

	  _stat->create_expr_percent         ("percent_instruction_"+toString(name), "nb_inst_instruction_"+toString(i), sum_nb_inst_instruction, toString(_("Percent instruction retire ok by cycle (instruction %s)"),name.c_str()));
	}
    }

    // bank/queue occupation
    {
      std::string sum_bank_nb_inst = "";
      for (uint32_t i=0; i<_param->_nb_bank; i++)
        {
          _stat_bank_nb_inst [i] = _stat->create_variable("bank_nb_inst_"+toString(i));
          
          _stat->create_expr_average_by_cycle("average_occupation_bank_"+toString(i), "bank_nb_inst_"+toString(i), "", toString(_("Average instruction by cycle (bank %d)"),i));
          _stat->create_expr_percent         ("percent_occupation_bank_"+toString(i), "average_occupation_bank_"+toString(i), toString(_param->_size_bank), toString(_("Percent occupation of bank (bank %d)"),i));
          
          if (i == 0)
            sum_bank_nb_inst = "bank_nb_inst_"+toString(i);
          else
            sum_bank_nb_inst = "+ bank_nb_inst_"+toString(i) + " " +sum_bank_nb_inst;
        }
      
      _stat->create_expr_average_by_cycle("average_occupation_bank", sum_bank_nb_inst, "", _("Average instruction by cycle (all bank)"));
      _stat->create_expr_percent         ("percent_occupation_bank" , "average_occupation_bank", toString(_param->_size_queue), _("Percent occupation of Re-Order-Buffer (all bank)"));
    }

    _stat_nb_inst_insert         = new counters_t * [_param->_nb_rename_unit];
    _stat_nb_inst_retire         = new counters_t * [_param->_nb_rename_unit];
    _stat_nb_inst_commit         = new counters_t * [_param->_nb_rename_unit];

    std::string average_nb_inst_commit = "0";
    
    for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
      {
        _stat_nb_inst_insert [i] = _stat->create_counters("nb_inst_insert_"+toString(i),_param->_nb_inst_insert[i],"",
                                                          _("Cycle number with %d instruction(s) included ")+toString(_("(rename_unit %d)."),i),
                                                          _("Percent of cycle number with %d instruction(s) included ")+toString(_("(rename_unit %d)."),i),
                                                          _("Average of instruction(s) included ")+toString(_("(rename_unit %d)."),i)
                                                          );
        
        _stat_nb_inst_retire [i] = _stat->create_counters("nb_inst_retire_"+toString(i),_param->_nb_inst_retire[i],"",
                                                          _("Cycle number with %d instruction(s) removed ")+toString(_("(rename_unit %d)."),i),
                                                          _("Percent of cycle number with %d instruction(s) removed ")+toString(_("(rename_unit %d)."),i),
                                                          _("Average of instruction(s) removed ")+toString(_("(rename_unit %d)."),i)
                                                          );
        
        _stat_nb_inst_commit [i] = _stat->create_counters("nb_inst_commit_"+toString(i),_param->_nb_inst_commit,"",
                                                          _("Cycle number with %d instruction(s) commited ")+toString(_("(rename_unit %d)."),i),
                                                          _("Percent of cycle number with %d instruction(s) commited ")+toString(_("(rename_unit %d)."),i),
                                                          _("Average of instruction(s) commited ")+toString(_("(rename_unit %d)."),i)
                                                          );

        average_nb_inst_commit = "+ average_nb_inst_commit_"+toString(i) + " " + average_nb_inst_commit;
      }

    _stat_nb_inst_commit_conflit_access = _stat->create_variable("nb_inst_commit_conflit_access");
    _stat->create_expr_average_by_cycle("average_use_interface_commit_conflit_access","nb_inst_commit_conflit_access", "", _("Average access conflit by cycle on commit interface"));
    _stat->create_expr_percent         ("percent_use_interface_commit_conflit_access","average_use_interface_commit_conflit_access", average_nb_inst_commit, _("Percent access conflit on commit interface"));


//  ALLOC1(_stat_last_inst          ,uint32_t          ,_param->_nb_thread);
    ALLOC1(_stat_last_inst_type     ,uint32_t          ,_param->_nb_thread);
    ALLOC1(_stat_last_inst_operation,uint32_t          ,_param->_nb_thread);
    ALLOC1(_stat_inst_fusion        ,stat_inst_fusion_t,_param->_nb_thread);

    for (uint32_t i=0; i<_param->_nb_thread; ++i)
      {
      //_stat_last_inst           [i] = INSTRUCTION_L_NOP;
        _stat_last_inst_type      [i] = instruction_information(INSTRUCTION_L_NOP)._type     ;
        _stat_last_inst_operation [i] = instruction_information(INSTRUCTION_L_NOP)._operation;
      }

    log_end(Commit_unit,FUNCTION);
  };

}; // end namespace commit_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
