/*
 * $Id: top_allocation.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Generic/Counter/SelfTest/include/top.h"
#include "Behavioural/include/Allocation.h"

void top::allocation (void)
{
  cout << "<" << name << "> : Construction of component" << endl;
  
  try 
    {
      param->test();
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      return;
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }
#ifdef STATISTICS
  param_stat = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//_usage = usage_unset(_usage,USE_SYSTEMC              );
//_usage = usage_unset(_usage,USE_VHDL                 );
//_usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//_usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//_usage = usage_unset(_usage,USE_POSITION             );
//_usage = usage_unset(_usage,USE_STATISTICS           );
//_usage = usage_unset(_usage,USE_INFORMATION          );

  cout << "<" << name << "> Create component" << endl;

  component = new Counter 
    (name.c_str(),
#ifdef STATISTICS
     param_stat,
#endif
     param,
     _usage);

#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  cout << "<" << name << "> Create signal" << endl;

  in_CLOCK  = new sc_clock ("clock", TIME_PERIOD, TIME_UNIT, 0.5); //name,period,time_unit,duty_cycle

  ALLOC0_SC_SIGNAL( in_NRESET        ," in_NRESET        ",Tcontrol_t);
  ALLOC1_SC_SIGNAL( in_COUNTER_DATA  ," in_COUNTER_DATA  ",Tdata_t   ,param->_nb_port);
  ALLOC1_SC_SIGNAL( in_COUNTER_ADDSUB," in_COUNTER_ADDSUB",Tcontrol_t,param->_nb_port);
  ALLOC1_SC_SIGNAL(out_COUNTER_DATA  ,"out_COUNTER_DATA  ",Tdata_t   ,param->_nb_port);

  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of component" << endl;
 
  INSTANCE0_SC_SIGNAL(component, in_CLOCK         );
  INSTANCE0_SC_SIGNAL(component, in_NRESET        );
  INSTANCE1_SC_SIGNAL(component, in_COUNTER_DATA  ,param->_nb_port);
  INSTANCE1_SC_SIGNAL(component, in_COUNTER_ADDSUB,param->_nb_port);
  INSTANCE1_SC_SIGNAL(component,out_COUNTER_DATA  ,param->_nb_port);
#endif
}
