/*
 * $Id$
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/@DIRECTORY/SelfTest/include/top.h"
#include "Behavioural/include/Allocation.h"

void top::test (void)
{
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
      msgInformation(_("<%s> : Start Simulation ............\n"),name.c_str());
      
      Time * _time = new Time();
      
      /********************************************************
       * Simulation - Begin
       ********************************************************/
      
      // Initialisation
      
      const uint32_t seed = 0;
    //const uint32_t seed = static_cast<uint32_t>(time(NULL));
      
      srand(seed);
      
      SC_CYCLE(0);
      LABEL("Initialisation");
      
      LABEL("Reset");
      in_NRESET->write(0);
      SC_CYCLE(5);
      in_NRESET->write(1);  
      
      LABEL("Loop of Test");
      
      for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
        {
          LABEL("Iteration %d",iteration);
          
          SC_CYCLE(1);
        }
      
      /********************************************************
       * Simulation - End
       ********************************************************/
      
      TEST_OK ("");
      
      sc_stop();
      delete _time;
      
      msgInformation(_("<%s> : ............ Stop Simulation\n"),name.c_str());
    }
#endif
}
