#ifndef Morpheo_Debug_type_h
#define Morpheo_Debug_type_h

/*
 * $Id: Debug_type.h 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 *  Debug's Level :
 *  - None    : print elementary information
 *  - Info    : print basic information
 *  - Trace   : trace internal variable
 *  - Func    : trace call and return function
 *  - All     : print all information
 */

#include "Common/include/ToString.h"
#include "Common/include/FromString.h"


namespace morpheo {

typedef enum 
  {
    DEBUG_NONE ,
    DEBUG_INFO ,
    DEBUG_TRACE,
    DEBUG_FUNC ,
    DEBUG_ALL
  } debug_verbosity_t;

  template<> inline std::string toString<debug_verbosity_t>(const debug_verbosity_t& x)
  {
    switch (x)
      {
      case DEBUG_NONE  : return "debug_none" ; break;
      case DEBUG_INFO  : return "debug_info" ; break;
      case DEBUG_TRACE : return "debug_trace"; break;
      case DEBUG_FUNC  : return "debug_func" ; break;
      case DEBUG_ALL   : return "debug_all"  ; break;
      default    : return ""      ; break;
      }
  };

  template<> inline debug_verbosity_t fromString<debug_verbosity_t>(const std::string& x)
  {
    if ((x.compare(toString(static_cast<uint32_t>(DEBUG_NONE ))) == 0) or
        (x.compare(toString(                      DEBUG_NONE  )) == 0))
      return DEBUG_NONE;

    if ((x.compare(toString(static_cast<uint32_t>(DEBUG_INFO ))) == 0) or
        (x.compare(toString(                      DEBUG_INFO  )) == 0))
      return DEBUG_INFO;

    if ((x.compare(toString(static_cast<uint32_t>(DEBUG_TRACE))) == 0) or
        (x.compare(toString(                      DEBUG_TRACE )) == 0))
      return DEBUG_TRACE;

    if ((x.compare(toString(static_cast<uint32_t>(DEBUG_FUNC ))) == 0) or
        (x.compare(toString(                      DEBUG_FUNC  )) == 0))
      return DEBUG_FUNC;

    if ((x.compare(toString(static_cast<uint32_t>(DEBUG_ALL  ))) == 0) or
        (x.compare(toString(                      DEBUG_ALL   )) == 0))
      return DEBUG_ALL;

#ifdef DEBUG
    return DEBUG;
#else
    return DEBUG_NONE ;
#endif
  };

}; // end namespace morpheo
#endif
