#!/bin/sh

#-----[ distcc_run_main ]----------------------------------------------
function distcc_run_main ()
{
    local hosts="${DISTCC_HOSTS}";

    export DISTCC_HOSTS="";
    for line in ${hosts}; do
        host=$(echo ${line} | cut -d/ -f1);
        echo " * station : ${host}";

        # launch service

        ssh ${host} ${MORPHEO_SCRIPT}/distcc.sh ${1};

        # if ssh is ok, insert line in DISTCC_HOSTS
        if test "$?" -eq "0"; then
            export DISTCC_HOSTS="$DISTCC_HOSTS ${line}";
        fi;
    done;
}

#-----[ Body ]----------------------------------------------
distcc_run_main ${*};
