/*
 * $Id: main.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "TopLevel/SelfTest/include/test.h"

#define NB_PARAMS 3

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * filename_simulator (string)\n"));
  err (_(" * filename_generator (string)\n"));
  err (_(" * filename_instance  (string)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  for (int32_t i=0; i<argc; ++i)
    msg("%s ",argv[i]);
  msg("\n");

  if (argc != static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name               = argv[x++];
  string filename_simulator = argv[x++];
  string filename_generator = argv[x++];
  string filename_instance  = argv[x++];

  int _return = EXIT_SUCCESS;
  try 
    {
      test (name,
            filename_simulator,
            filename_generator,
            filename_instance,
            NULL
// &(morpheo::behavioural::custom::example_get_custom_information)
            );
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Morpheo : no error");
      else
	TEST_KO("Morpheo : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
