#ifndef morpheo_behavioural_core_core_glue_Parameters_h
#define morpheo_behavioural_core_core_glue_Parameters_h

/*
 * $Id: Parameters.h 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Types.h"
#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace core_glue {

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t                _nb_front_end                         ;
  public : uint32_t              * _nb_context                           ;//[nb_front_end]
  public : uint32_t                _nb_ooo_engine                        ;
  public : uint32_t                _nb_execute_loop                      ;
  public : uint32_t              * _ooo_engine_nb_front_end              ;//[nb_ooo_engine]
  public : uint32_t              * _ooo_engine_nb_execute_loop           ;//[nb_ooo_engine]
  public : uint32_t              * _execute_loop_nb_ooo_engine           ;//[nb_execute_loop]
  public : uint32_t              * _nb_inst_decod                        ;//[nb_front_end] -> [sum_inst_decod]
  public : uint32_t              * _front_end_nb_inst_branch_complete    ;//[nb_front_end]
  public : uint32_t              * _ooo_engine_nb_inst_branch_complete   ;//[nb_ooo_engine]
//public : uint32_t              * _nb_inst_insert                       ;//[nb_ooo_engine]
  public : uint32_t              * _nb_inst_reexecute                    ;//[nb_ooo_engine]
  public : uint32_t              * _nb_inst_issue_queue                  ;//[nb_ooo_engine]
//public : uint32_t              * _nb_inst_issue_slot                   ;//[nb_ooo_engine]
  public : uint32_t             ** _nb_inst_execute                      ;//[nb_ooo_engine][ooo_engine_nb_execute_loop]
  public : bool                  * _issue_queue_in_order                 ;//[nb_ooo_engine]
  public : uint32_t              * _nb_read_unit                         ;//[nb_execute_loop]
  public : uint32_t              * _nb_write_unit                        ;//[nb_execute_loop]
//public : uint32_t                _size_depth                           ;
//public : uint32_t                _size_rob_ptr                         ;
//public : uint32_t                _size_load_queue_ptr                  ;
//public : uint32_t                _size_store_queue_ptr                 ;
//public : uint32_t                _size_general_data                    ;
//public : uint32_t                _size_special_data                    ;
//public : uint32_t                _size_general_register                ;
//public : uint32_t                _size_special_register                ;
//public : uint32_t                _size_front_end_id                    ;
//public : uint32_t                _size_context_id                      ;
//public : uint32_t                _size_ooo_engine_id                   ;
  public : Tpriority_t             _dispatch_priority                    ;
  public : Tload_balancing_t       _dispatch_load_balancing              ;
//public : bool               **** _table_dispatch                       ;//[nb_ooo_engine][nb_inst_issue_slot][execute_loop][nb_read_unit]
  public : bool                *** _table_issue_type                     ;//                                   [execute_loop][nb_read_unit][nb_type]
  public : bool                *** _table_issue_thread                   ;//                                   [execute_loop][nb_read_unit][nb_thread]

  public : uint32_t             ** _translate_ooo_engine_num_front_end   ;//[nb_ooo_engine][ooo_engine_nb_front_end]
  public : uint32_t             ** _translate_ooo_engine_num_execute_loop;//[nb_ooo_engine][ooo_engine_nb_execute_loop]
  public : uint32_t             ** _translate_execute_loop_num_ooo_engine;//[nb_execute_loop][execute_loop_nb_ooo_engine]
  public : uint32_t            *** _translate_num_context_to_num_thread  ;//[nb_ooo_engine][ooo_engine_nb_front_end][nb_context]

  public : uint32_t              * _link_ooo_engine_with_front_end                          ;//[nb_front_end]
  public : uint32_t              * _translate_num_front_end_to_ooo_engine_front_end_id      ;//[nb_front_end]

  public : uint32_t             ** _translate_num_execute_loop_to_ooo_engine_execute_loop_id;//[nb_execute_loop][execute_loop_nb_ooo_engine]
  public : Tcontext_t           ** _translate_num_ooo_engine_to_execute_loop_ooo_engine_id  ;//[nb_ooo_engine][nb_execute_loop]

//public : uint32_t             ** _execute_loop_nb_inst_insert                             ;//[nb_execute_loop][execute_loop_nb_ooo_engine]
//public : uint32_t             ** _execute_loop_nb_inst_issue_slot                         ;//[nb_execute_loop][execute_loop_nb_ooo_engine]
//public : uint32_t              * _link_execute_loop_with_ooo_engine                       ;//[nb_ooo_engine]

  public : uint32_t                _max_ooo_engine_nb_inst_branch_complete;
  public : uint32_t                _max_front_end_nb_inst_branch_complete ;
  public : uint32_t                _max_ooo_engine_nb_execute_loop        ;
  public : uint32_t                _max_nb_inst_execute                   ;
  public : uint32_t                _max_nb_write_unit                     ;
//public : uint32_t                _max_nb_inst_insert                    ;
  public : uint32_t                _max_nb_inst_issue_queue               ;
//public : uint32_t                _max_nb_inst_issue_slot                ;
  public : uint32_t                _max_nb_read_unit                      ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  
  (uint32_t                nb_front_end                         ,
   uint32_t              * nb_context                           ,//[nb_front_end]
   uint32_t                nb_ooo_engine                        ,
   uint32_t                nb_execute_loop                      ,
   uint32_t              * ooo_engine_nb_front_end              ,//[nb_ooo_engine]
   uint32_t              * ooo_engine_nb_execute_loop           ,//[nb_ooo_engine]
   uint32_t              * execute_loop_nb_ooo_engine           ,//[nb_execute_loop]
   uint32_t              * nb_inst_decod                        ,//[nb_front_end] -> [sum_inst_decod]
   uint32_t              * front_end_nb_inst_branch_complete    ,//[nb_front_end]
   uint32_t              * ooo_engine_nb_inst_branch_complete   ,//[nb_ooo_engine]
// uint32_t              * nb_inst_insert                       ,//[nb_ooo_engine]
   uint32_t              * nb_inst_reexecute                    ,//[nb_ooo_engine]
   uint32_t              * nb_inst_issue_queue                  ,//[nb_ooo_engine]
// uint32_t              * nb_inst_issue_slot                   ,//[nb_ooo_engine]
   uint32_t             ** nb_inst_execute                      ,//[nb_ooo_engine][ooo_engine_nb_execute_loop]
   bool                  * issue_queue_in_order                 ,//[nb_ooo_engine]
   uint32_t              * nb_read_unit                         ,//[nb_execute_loop]
   uint32_t              * nb_write_unit                        ,//[nb_execute_loop]
   uint32_t                size_depth                           ,
   uint32_t                size_rob_ptr                         ,
   uint32_t                size_load_queue_ptr                  ,
   uint32_t                size_store_queue_ptr                 ,
   uint32_t                size_general_data                    ,
   uint32_t                size_special_data                    ,
   uint32_t                size_general_register                ,
   uint32_t                size_special_register                ,
   Tpriority_t             dispatch_priority                    ,
   Tload_balancing_t       dispatch_load_balancing              ,
// bool               **** table_dispatch                       ,//[nb_ooo_engine][nb_inst_issue_slot][execute_loop][nb_read_unit]
   bool                *** table_issue_type                     ,//                                   [execute_loop][nb_read_unit][nb_type]
   bool                *** table_issue_thread                   ,//                                   [execute_loop][nb_read_unit][nb_thread]
   uint32_t             ** translate_ooo_engine_num_front_end   ,//[nb_ooo_engine][ooo_engine_nb_front_end]
   uint32_t             ** translate_ooo_engine_num_execute_loop,//[nb_ooo_engine][ooo_engine_nb_execute_loop]
   uint32_t             ** translate_execute_loop_num_ooo_engine,//[nb_execute_loop][execute_loop_nb_ooo_engine]
   uint32_t            *** translate_num_context_to_num_thread  ,//[nb_ooo_engine][ooo_engine_nb_front_end][nb_context]

   bool                    is_toplevel=false);

//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::core_glue::Parameters & x);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
