/*
 * $Id: Parameters_msg_error.cpp 138 2010-05-12 17:34:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Test.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {


#undef  FUNCTION
#define FUNCTION "Load_store_unit::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");
    
    Parameters_test test("Load_store_unit");

    switch (_speculative_load)
      {
      case SPECULATIVE_LOAD_ACCESS :
	{
	  if (not (_nb_bypass_memory == 0))
	    test.error(_("Bypass memory is not supported. Please wait a next revision.\n"));
 
	  break;
	}
      case NO_SPECULATIVE_LOAD     :
      // case SPECULATIVE_LOAD_BYPASS :
      // case SPECULATIVE_LOAD_COMMIT :
      default                      :
	{
	  if (not (_nb_bypass_memory == 0))
	    test.error(toString(_("In the load scheme '%s', they have none bypass.\n"),toString(_speculative_load).c_str()));

	  test.error(toString(_("Speculative load scheme '%s' is not supported. Please wait a next revision.\n"),toString(_speculative_load).c_str()));
	  break;
	}
      }

    if (not (_size_store_queue >= 2))
      test.error(_("Store queue must have at less two slot.\n"));

    if (not (_nb_bypass_memory <= _size_load_queue))
      test.error(_("Bypass number must be less than load_queue's size.\n"));

    if (not is_multiple(_nb_store_queue_bank,_nb_inst_memory))
      test.error(_("Number of bank of store queue must be a multiple of number input instruction.\n"));

    if (not is_multiple(_nb_load_queue_bank,_nb_inst_memory))
      test.error(_("Number of bank of load queue must be a multiple of number input instruction.\n"));
    
    switch (_speculative_commit_predictor_scheme)
      {
      case PREDICTOR_NEVER_TAKE  :
      case PREDICTOR_ALWAYS_TAKE :
      case PREDICTOR_COUNTER     :
        {
          break;
        }
      case PREDICTOR_STATIC      :
      case PREDICTOR_LAST_TAKE   :
      case PREDICTOR_LOCAL       :
      case PREDICTOR_GLOBAL      :
      case PREDICTOR_META        :
      case PREDICTOR_CUSTOM      :
        {
          test.error(toString(_("Predictor scheme \"%s\" is unsupported for load scheme.\n"),toString(_speculative_commit_predictor_scheme).c_str()));
          break;
        }
      }
    
    if (_nb_cache_port > 1)
      test.warning(_("nb_cache_port > 1 is unsupported (Coming Soon).\n")); 

    if (_nb_inst_memory > 1)
      test.warning(_("nb_inst_memory > 1 is unsupported (Coming Soon).\n")); 

    log_printf(FUNC,Load_store_unit,FUNCTION,"End");

    return test;

  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
