#ifdef VHDL
/*
 * $Id: Shifter_vhdl_declaration.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Shifter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace shifter {


  void Shifter::vhdl_declaration (Vhdl * & vhdl)
  {
    uint32_t log2_size_data = static_cast<uint32_t>(ceil(log2(_param->_size_data)));

    vhdl->set_constant("cst_is_direction_left  ",1,_left      );
    vhdl->set_constant("cst_is_direction_right ",1,_right     );
    vhdl->set_constant("cst_is_type_shift      ",1,_shift     );
    vhdl->set_constant("cst_is_type_rotate     ",1,_rotate    );
    vhdl->set_constant("cst_is_carry_arithmetic",1,_arithmetic);
    vhdl->set_constant("cst_is_carry_logic     ",1,_logic     );
    vhdl->set_constant("cst_completion         ",_param->_size_data,"(others => '1')");
    
    for (uint32_t i=0; i<_param->_nb_port; i++)
      {
	if (_param->_shift_value != 0)
	  vhdl->set_constant("shift_"+toString(i),log2_size_data, _param->_shift_value);
	else
	  vhdl->set_alias   ("shift_"+toString(i),std_logic(log2_size_data), "in_SHIFTER_"+toString(i)+"_SHIFT",std_logic_range(log2_size_data));
	
	if (_param->_size_data_completion > 0)
	  {
	    vhdl->set_signal ("shifter_completion_left_"+toString(i)+" ",_param->_size_data);
	    vhdl->set_signal ("shifter_completion_right_"+toString(i)+"",_param->_size_data);
	    vhdl->set_signal ("mask_completion_left_"+toString(i)+"    ",_param->_size_data);
	    vhdl->set_signal ("mask_completion_right_"+toString(i)+"   ",_param->_size_data);
	  }
	
	//-----[ Shift logic Left ]--------------------------------------------
	if (_param->_have_shift_logic_left)
	  vhdl->set_signal ("shift_logic_left_"+toString(i)+"      ",_param->_size_data);
	
	//-----[ Shift logic Right ]-------------------------------------------
	if (_param->_have_shift_logic_right)
	  vhdl->set_signal ("shift_logic_right_"+toString(i)+"     ",_param->_size_data);
	
	//-----[ Shift arithmetic Left ]---------------------------------------
	if (_param->_have_shift_arithmetic_left)
	  vhdl->set_signal ("shift_arithmetic_left_"+toString(i)+" ",_param->_size_data);
	
	//-----[ Shift arithmetic Right ]--------------------------------------
	if (_param->_have_shift_arithmetic_right)
	  vhdl->set_signal ("shift_arithmetic_right_"+toString(i)+"",_param->_size_data);
	
	//-----[ Rotate Left ]-------------------------------------------------
	if (_param->_have_rotate_left)
	  vhdl->set_signal ("rotate_left_"+toString(i)+"           ",_param->_size_data);
	
	//-----[ Rotate Right ]------------------------------------------------
	if (_param->_have_rotate_right)
	  vhdl->set_signal ("rotate_right_"+toString(i)+"          ",_param->_size_data);
      }
  };

}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
