/*
 * $Id: Translation.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Environment.h"
#include "Common/include/Translation.h"
#include "Common/include/ErrorMorpheo.h"

namespace morpheo {

#ifdef TRANSLATION
  static bool translation_initialized;
#endif

  void translation (void)
  {
#ifdef TRANSLATION
    if (not translation_initialized)
      {
        environment();
        
        std::string dirname = MORPHEO_TOPLEVEL;
        dirname += "/IPs/systemC/processor/Morpheo/locale";

        if (bindtextdomain(MORPHEO_PACKAGE,dirname.c_str()) == NULL)
          throw ERRORMORPHEO("Translation","Error in set directory containing message catalogs.\n");
        
        translation_initialized = true;
      }
#endif    
  }

}; // end namespace morpheo
