#!/bin/bash

#-----------------------------------------------------------
# $Id: distexe_execute.sh 138 2010-05-12 17:34:01Z rosiere $
#-----------------------------------------------------------

#-----[ global variable ]-----------------------------------
declare -i TRAP=0;

#-----[ distexe_execute_usage ]-----------------------------
function distexe_execute_usage ()
{
    echo "Usage     : ${0} path_work file_cmd file_cpt file_host lock_process id";
    echo "Arguments : ";
    echo " * path_work    : directory to execute command";
    echo " * file_cmd     : list of command";
    echo " * file_cpt     : file with the index of next command to execute";
    echo " * file_process : if file is present, station is running";
    echo " * lock_process : file to lock process";
    echo " * id           : identification";
    exit;
}

#-----[ distexe_execute_test_usage ]------------------------
function distexe_execute_test_usage ()
{
    if test ${#} -ne 6; then
	distexe_execute_usage;
    fi;

    if test -z "${MORPHEO_SCRIPT}"; then
        echo "Environment variable MORPHEO_SCRIPT is not set";
        distexe_execute_usage;
    fi;

    if test ! -d ${1}; then
        echo "Directory ${1} is invalid";
    fi;
}

#-----[ distexe_execute_end ]----------------------------
function distexe_execute_end()
{
    ${MORPHEO_SCRIPT}/lock.sh   ${LOCK_PROCESS};
    rm -f ${FILE_PROCESS};
    ${MORPHEO_SCRIPT}/unlock.sh ${LOCK_PROCESS};
}

#-----[ distexe_execute_no_trap ]------------------------
function distexe_execute_no_trap()
{
    TRAP=1;
}

#-----[ distexe_execute_trap ]---------------------------
function distexe_execute_trap()
{
#    echo "  * {"$(${MORPHEO_SCRIPT}/date.sh)"} <${HOSTNAME}> %%%%%%%%%%%%%%%% HITTTTTTTTTTTTTTTTTT %%%%%%%%%%%%%%%%";

    rm -f ${LOCK_CPT}

    distexe_execute_end;
    exit 1;
}

#-----[ distexe_execute ]-----------------------------------
function distexe_execute ()
{
    trap distexe_execute_no_trap INT TERM;

    # test_usage
    distexe_execute_test_usage ${*};

    local -a COMMAND;
    local -i CPT_OLD;
    local -i CPT;
    local    PATH_WORK=${1};
    local    FILE_CMD=${2};
    local    FILE_CPT=${3};
    local    FILE_PROCESS=${4};
    local    LOCK_PROCESS=${5};
    local    ID=${6};
    local    LOCK_CPT="${PATH_WORK}/distexe-cpt-lock";
    local    OUTPUT_FILE_INFO="distexe.info";
    local    OUTPUT_FILE_CMD="distexe.command";
    local    OUTPUT_FILE_OUT="distexe.output";

    echo $$ > ${FILE_PROCESS};

#   echo "  * {"$(${MORPHEO_SCRIPT}/date.sh)"} <${ID}> pid is $$";
    # Init CPT if this thread is the first
    ${MORPHEO_SCRIPT}/lock.sh   ${LOCK_CPT};
    if test ! -s ${FILE_CPT}; then
        echo "  * {"$(${MORPHEO_SCRIPT}/date.sh)"} <${ID}> create counter file ${FILE_CPT}";
	echo "0" > ${FILE_CPT};
    fi;
    ${MORPHEO_SCRIPT}/unlock.sh ${LOCK_CPT};

    trap distexe_execute_trap INT TERM;

    if test ${TRAP} -eq 1; then
        distexe_execute_trap;
    fi;

    # read, line by line, the command file and write in array
    CPT=0;

    while read line; do
	COMMAND[${CPT}]="${line}";
	CPT=$((${CPT}+1));
    done < ${FILE_CMD};

    local -i NB_DIGIT=0;
    local -i NB_COMMAND=${#COMMAND[*]};
    local -i x=${NB_COMMAND};

    while test ${x} -ne 0; do
        NB_DIGIT=$((${NB_DIGIT} + 1));
        x=$((${x} / 10));
    done;

    echo "  * {"$(${MORPHEO_SCRIPT}/date.sh)"} <${ID}> is ready";

    # infinite loop
    CPT_OLD=0;
    CPT=0;

    while test 1; do
	# Take a number
	CPT_OLD=${CPT};

        # Read the index, and increase
	${MORPHEO_SCRIPT}/lock.sh   ${LOCK_CPT};
	CPT=$(cat ${FILE_CPT});
	echo "$((${CPT}+1))" > ${FILE_CPT};
	${MORPHEO_SCRIPT}/unlock.sh ${LOCK_CPT};

        # test if this number is valid
	if test ${CPT} -ge ${NB_COMMAND}; then
	    CPT=${NB_COMMAND};
	fi;

	# test if between the cpt_old and cpt, there are a synchronisation command

#	local -i CPT_SYNC=${CPT}_OLD;
#
#	while test ${CPT}_SYNC -lt ${CPT}; do
#	    if test -z "${COMMAND[${CPT}_SYNC]}"; then
#		echo "  * {"$(${MORPHEO_SCRIPT}/date.sh)"} <${ID}> synchronisation [${CPT}_SYNC]";
#	    fi;
#	    CPT_SYNC=$((${CPT}_SYNC+1));
#	done;

	# test if this number is valid
	if test ${CPT} -eq ${NB_COMMAND}; then
	    break;
	fi;

	# Test if command is empty !
	if test ! -z "${COMMAND[${CPT}]}"; then
            local NUM=$(printf %.${NB_DIGIT}d ${CPT});
            local MAX=$((${NB_COMMAND}-1));

#	    echo "  * {"$(${MORPHEO_SCRIPT}/date.sh)"} <${ID}> execute command [${NUM}] : ${COMMAND[${CPT}]}";
	    echo "  * {"$(${MORPHEO_SCRIPT}/date.sh)"} <${ID}> command [${NUM}/${MAX}] : execute";
	    local PATH_CURRENT=${PWD};

            cd    ${PATH_WORK}        &> /dev/null;
	    mkdir "Task_${NUM}"       &> /dev/null;
	    cd    "Task_${NUM}"       &> /dev/null;
            echo "id   : ${ID}"        >  ${OUTPUT_FILE_INFO};
            echo "host : ${HOSTNAME}" >>  ${OUTPUT_FILE_INFO};
            echo "pid  : $$"          >>  ${OUTPUT_FILE_INFO};
            echo "date : "$(${MORPHEO_SCRIPT}/date.sh)  >>  ${OUTPUT_FILE_INFO};
	    echo "#!/bin/bash"         >  ${OUTPUT_FILE_CMD};
	    echo 'source ${HOME}/.bashrc;' >>  ${OUTPUT_FILE_CMD};
	    echo "${COMMAND[${CPT}]}" >>  ${OUTPUT_FILE_CMD};
	    chmod +x                      ${OUTPUT_FILE_CMD};
	    ./${OUTPUT_FILE_CMD}      &>  ${OUTPUT_FILE_OUT};
	    cd    ${PATH_CURRENT}     &> /dev/null;
	    echo "  * {"$(${MORPHEO_SCRIPT}/date.sh)"} <${ID}> command [${NUM}/${MAX}] : done";
	fi;
    done;

    echo "  * {"$(${MORPHEO_SCRIPT}/date.sh)"} <${ID}> is done";
    
    distexe_execute_end;
}

#-----[ Corps ]---------------------------------------------
distexe_execute ${*};
