#ifdef SYSTEMC
/*
 * $Id: Execute_loop_Glue_genMealy_spr_write.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Execute_loop_Glue/include/Execute_loop_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace execute_loop_glue {


#undef  FUNCTION
#define FUNCTION "Execute_loop_Glue::genMealy_spr_write"
  void Execute_loop_Glue::genMealy_spr_write (void)
  {
    log_begin(Execute_loop_Glue,FUNCTION);

    if (PORT_READ(in_NRESET))
      {
    for (uint32_t i=0; i<_param->_nb_spr_write; i++)
      {
	Tcontrol_t         val           = PORT_READ(in_SPR_WRITE_WRITE_UNIT_VAL           [i]);
	Tcontrol_t         ack           = PORT_READ(in_SPR_WRITE_REGISTER_FILE_ACK        [i]);
	Tcontext_t         ooo_engine_id = (_param->_have_port_ooo_engine_id)?PORT_READ(in_SPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID [i]):0;
	Tspecial_address_t num_reg       = PORT_READ(in_SPR_WRITE_WRITE_UNIT_NUM_REG       [i]);
	Tspecial_data_t    data          = PORT_READ(in_SPR_WRITE_WRITE_UNIT_DATA          [i]);

	PORT_WRITE(out_SPR_WRITE_WRITE_UNIT_ACK               [i],ack          );
	
	PORT_WRITE(out_SPR_WRITE_REGISTER_FILE_VAL            [i],val          );
	if (_param->_have_port_ooo_engine_id)
	PORT_WRITE(out_SPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  [i],ooo_engine_id);
	PORT_WRITE(out_SPR_WRITE_REGISTER_FILE_NUM_REG        [i],num_reg      );
	PORT_WRITE(out_SPR_WRITE_REGISTER_FILE_DATA           [i],data         );
	
	PORT_WRITE(out_SPR_WRITE_READ_UNIT_VAL                [i],val and ack  ); // Transaction
	if (_param->_have_port_ooo_engine_id)
	PORT_WRITE(out_SPR_WRITE_READ_UNIT_OOO_ENGINE_ID      [i],ooo_engine_id);
	PORT_WRITE(out_SPR_WRITE_READ_UNIT_NUM_REG            [i],num_reg      );
	PORT_WRITE(out_SPR_WRITE_READ_UNIT_DATA               [i],data         );
      }
      }
    else
      {
        for (uint32_t i=0; i<_param->_nb_spr_write; i++)
          {
            PORT_WRITE(out_SPR_WRITE_WRITE_UNIT_ACK               [i],0);
            PORT_WRITE(out_SPR_WRITE_REGISTER_FILE_VAL            [i],0);
            PORT_WRITE(out_SPR_WRITE_READ_UNIT_VAL                [i],0);
          }
      }

    log_end(Execute_loop_Glue,FUNCTION);
  };

}; // end namespace execute_loop_glue
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
