#ifdef SYSTEMC
/*
 * $Id: Issue_queue_genMoore.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Issue_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::genMoore"
  void Issue_queue::genMoore (void)
  {
    log_begin(Issue_queue,FUNCTION);
    log_function(Issue_queue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    // ===================================================================
    // =====[ REEXECUTE_UNIT ]============================================
    // ===================================================================
    
    for (uint32_t i=0; i<_param->_nb_inst_reexecute; ++i)
      {
        log_printf(TRACE,Issue_queue,FUNCTION,"  * REEXECUTE [%d]",i);

        internal_REEXECUTE_ACK [i] = (_reexecute_queue.size()+i) < _param->_size_reexecute_queue;

        log_printf(TRACE,Issue_queue,FUNCTION,"    * ACK : %d",internal_REEXECUTE_ACK [i]);
      }

      }
    else
      {
        // Reset
        for (uint32_t i=0; i<_param->_nb_inst_reexecute; ++i)
          internal_REEXECUTE_ACK [i] = 0;
      }

    // Write Output
    for (uint32_t i=0; i<_param->_nb_inst_reexecute; ++i)
      PORT_WRITE(out_REEXECUTE_ACK [i], internal_REEXECUTE_ACK [i]);

    (this->*function_genMoore) ();

    log_end(Issue_queue,FUNCTION);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
