/*
 * $Id: top.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Counter/SelfTest/include/top.h"

#define NB_PARAMS 2

#ifdef MTI_SYSTEMC
SC_MODULE_EXPORT(top);
#endif

#ifdef MTI_SYSTEMC
SC_CTOR(top::top)
#else
top::top (sc_module_name module_name,int argc, char * argv[])
#endif
{
#ifdef MTI_SYSTEMC
  // accessing command-line arguments with modelsim
  int argc;
  const char * const * argv;

  argc = sc_argc ();
  argv = sc_argv ();
#endif

  if (argc != 2+NB_PARAMS)
    usage (argv[0]);

           name      = argv[1];
  uint32_t size_data = fromString<uint32_t>(argv[2]);
  uint32_t nb_port   = fromString<uint32_t>(argv[3]);

  param = new morpheo::behavioural::generic::counter::Parameters
    (size_data,
     nb_port  );
  
  // msg(_("%s"),param.print(0).c_str());
  
  // Allocation component
  allocation ();
  
#ifdef MTI_SYSTEMC
  SC_THREAD(test);
#endif
}

top::~top (void)
{
  cout << "<" << name << "> : destructior" << endl;

  deallocation ();
  delete param;
}
