/*
 * $Id: Multiplier_allocation.cpp 116 2009-04-30 13:51:41Z moulu $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Multiplier/include/Multiplier.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace multiplier {



#undef  FUNCTION
#define FUNCTION "Multiplier::allocation"
  void Multiplier::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_begin(Multiplier,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Multiplier"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface "multiplier" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("multiplier", IN, WEST, _("Multiplier's interface."));
      
      ALLOC0_SIGNAL_IN ( in_MULTIPLIER_DATA_IN_0,"data_in_0",Tdata_t   ,_param->_size_data);
      ALLOC0_SIGNAL_IN ( in_MULTIPLIER_DATA_IN_1,"data_in_1",Tdata_t   ,_param->_size_data);
      ALLOC0_SIGNAL_IN ( in_MULTIPLIER_NSTALL   ,"nstall"   ,Tcontrol_t,1);
      ALLOC0_SIGNAL_OUT(out_MULTIPLIER_DATA_LSB_OUT ,"data_lsb_out" ,Tdata_t   ,_param->_size_data);
      ALLOC0_SIGNAL_OUT(out_MULTIPLIER_DATA_MSB_OUT ,"data_msb_out" ,Tdata_t   ,_param->_size_data);

      ALLOC0_INTERFACE_END();
    }

     // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC_BODY))
      {
        _pipeline = new std::vector<result_t>(_param->_latency+1);
      }
#endif

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
	_component->generate_file();
#endif

    log_end(Multiplier,FUNCTION);
  };

}; // end namespace multiplier
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
