/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  10
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Generic/Victim/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::generic::victim::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Victim * _Victim = new Victim (name.c_str(),
#ifdef STATISTICS
				 _parameters_statistics,
#endif
				 _param,
				 _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_ACCESS_VAL    ," in_ACCESS_VAL    ",Tcontrol_t,_param->_nb_access);
  ALLOC1_SC_SIGNAL(out_ACCESS_ACK    ,"out_ACCESS_ACK    ",Tcontrol_t,_param->_nb_access);
  ALLOC1_SC_SIGNAL( in_ACCESS_ADDRESS," in_ACCESS_ADDRESS",Taddress_t,_param->_nb_access);
  ALLOC1_SC_SIGNAL( in_ACCESS_HIT    ," in_ACCESS_HIT    ",Tcontrol_t,_param->_nb_access);
  ALLOC1_SC_SIGNAL( in_ACCESS_ENTITY ," in_ACCESS_ENTITY ",Tentity_t ,_param->_nb_access);
  ALLOC1_SC_SIGNAL(out_ACCESS_VICTIM ,"out_ACCESS_VICTIM ",Tentity_t ,_param->_nb_access);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Victim.\n"),name.c_str());

  (*(_Victim->in_CLOCK))        (*(in_CLOCK));
  (*(_Victim->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Victim, in_ACCESS_VAL    ,_param->_nb_access);
  INSTANCE1_SC_SIGNAL(_Victim,out_ACCESS_ACK    ,_param->_nb_access);
  if (_param->_have_port_address)
  INSTANCE1_SC_SIGNAL(_Victim, in_ACCESS_ADDRESS,_param->_nb_access);
  INSTANCE1_SC_SIGNAL(_Victim, in_ACCESS_HIT    ,_param->_nb_access);
  INSTANCE1_SC_SIGNAL(_Victim, in_ACCESS_ENTITY ,_param->_nb_access);
  INSTANCE1_SC_SIGNAL(_Victim,out_ACCESS_VICTIM ,_param->_nb_access);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete _Victim;

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_ACCESS_VAL    ;
  delete [] out_ACCESS_ACK    ;
  delete []  in_ACCESS_ADDRESS;
  delete []  in_ACCESS_HIT    ;
  delete []  in_ACCESS_ENTITY ;
  delete [] out_ACCESS_VICTIM ;
#endif

#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
