#ifdef SYSTEMC
/*
 * $Id: Simulation.cpp 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Simulation.h"
#include "Common/include/ErrorMorpheo.h"

namespace morpheo              {
namespace behavioural          {

  static bool          simulation_initialized;
  bool                _simulation_stop_exception;
  double              _simulation_nb_cycle;
  double              _simulation_nb_instruction;
  std::vector<double> _simulation_nb_instruction_commited;
  stop_type_t         _simulation_stop_type;
  bool                _simulation_file_with_date;
  bool                _simulation_file_with_pid ;

  Model               _model;

  void simulation_init (double      nb_cycle,
                        double      debug_nb_cycle,
                        double      nb_instruction,
                        stop_type_t stop_type,
                        bool        file_with_date,
                        bool        file_with_pid )
  {
    if (not simulation_initialized)
      {
        if (debug_nb_cycle == 0)
          {
            _simulation_nb_cycle                = nb_cycle;
            _simulation_stop_exception          = false;
          }
        else
          {
            _simulation_nb_cycle                = (debug_nb_cycle<nb_cycle)?debug_nb_cycle:nb_cycle;
            _simulation_stop_exception          = (debug_nb_cycle<nb_cycle);
          }

        _simulation_nb_instruction          = nb_instruction;
//      _simulation_nb_instruction_commited = new std::vector<double>;
        _simulation_stop_type               = stop_type;
        _simulation_file_with_date          = file_with_date;
        _simulation_file_with_pid           = file_with_pid ;

        simulation_initialized = true;
      }
    else
      {
        msg_printf(WARNING,_("Multi instance of Morpheo : stop condition, take the highest."));

        if (//(_simulation_nb_cycle == 0) or
            (_simulation_nb_cycle < debug_nb_cycle))
          {
            _simulation_nb_cycle       = debug_nb_cycle;
            _simulation_stop_exception = true;
          }

        if (//(_simulation_nb_cycle == 0) or
            (_simulation_nb_cycle < nb_cycle))
          {
            _simulation_nb_cycle       = nb_cycle;
            _simulation_stop_exception = false;
          }
        
        if (//(_simulation_nb_instruction == 0) or
            (_simulation_nb_instruction < nb_instruction))
          _simulation_nb_instruction = nb_instruction;

        _simulation_file_with_date          |= file_with_date;
        _simulation_file_with_pid           |= file_with_pid ;
      }
  }
    
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
