/*
 * $Id: main.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/SelfTest/include/test.h"

#define NB_PARAMS 16

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * size_context_id                            (uint32_t         )\n"));
  err (_(" * size_front_end_id                          (uint32_t         )\n"));
  err (_(" * size_packet_id                             (uint32_t         )\n"));
  err (_(" * size_queue                                 (uint32_t         )\n"));
  err (_(" * nb_execute_loop                            (uint32_t         )\n"));
  err (_(" * nb_inst_execute          [nb_execute_loop] (uint32_t         )\n"));
  err (_(" * nb_inst_commit                             (uint32_t         )\n"));
  err (_(" * nb_inst_reexecute                          (uint32_t         )\n"));
  err (_(" * nb_inst_reexecute_commit                   (uint32_t         )\n"));
  err (_(" * nb_execute_loop_select                     (uint32_t         )\n"));
  err (_(" * priority                                   (Tpriority_t      )\n"));
  err (_(" * load_balancing                             (Tload_balancing_t)\n"));
  err (_(" * size_general_register_id                   (uint32_t         )\n"));
  err (_(" * size_special_register_id                   (uint32_t         )\n"));
  err (_(" * size_general_data                          (uint32_t         )\n"));
  err (_(" * size_special_data                          (uint32_t         )\n"));
  err (_(" * size_store_queue_ptr                       (uint32_t         )\n"));
  err (_(" * size_load_queue_ptr                        (uint32_t         )\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc <= static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];
  uint32_t            _size_context_id          = fromString<uint32_t         >(argv[x++]);
  uint32_t            _size_front_end_id        = fromString<uint32_t         >(argv[x++]);
  uint32_t            _size_packet_id           = fromString<uint32_t         >(argv[x++]);
  uint32_t            _size_queue               = fromString<uint32_t         >(argv[x++]);
  uint32_t            _nb_execute_loop          = fromString<uint32_t         >(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+_nb_execute_loop))
    usage (argc, argv);

  uint32_t          * _nb_inst_execute          = new uint32_t [_nb_execute_loop];
  for (uint32_t i=0; i<_nb_execute_loop; i++)
    _nb_inst_execute [i] = fromString<uint32_t>(argv[x++]);

  uint32_t            _nb_inst_commit           = fromString<uint32_t         >(argv[x++]);
  uint32_t            _nb_inst_reexecute        = fromString<uint32_t         >(argv[x++]);
  uint32_t            _nb_execute_loop_select   = fromString<uint32_t         >(argv[x++]);
  Tpriority_t         _priority                 = fromString<Tpriority_t      >(argv[x++]);
  Tload_balancing_t   _load_balancing           = fromString<Tload_balancing_t>(argv[x++]);
  uint32_t            _size_general_register_id = fromString<uint32_t         >(argv[x++]);
  uint32_t            _size_special_register_id = fromString<uint32_t         >(argv[x++]);
  uint32_t            _size_general_data        = fromString<uint32_t         >(argv[x++]);
  uint32_t            _size_special_data        = fromString<uint32_t         >(argv[x++]);
  uint32_t            _size_store_queue_ptr     = fromString<uint32_t         >(argv[x++]);
  uint32_t            _size_load_queue_ptr      = fromString<uint32_t         >(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::reexecute_unit::Parameters * param = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::reexecute_unit::Parameters
	(
	 _size_context_id         ,
	 _size_front_end_id       ,
	 _size_packet_id          ,
	 _size_queue              ,
	 _nb_execute_loop         ,
	 _nb_inst_execute         ,
	 _nb_inst_commit          ,
	 _nb_inst_reexecute       ,
	 _nb_execute_loop_select  ,
	 _priority                ,
	 _load_balancing          ,
	 _size_general_register_id,
	 _size_special_register_id,
	 _size_general_data       ,
	 _size_special_data       ,
	 _size_store_queue_ptr    ,
	 _size_load_queue_ptr     ,
         true //is_toplevel
        );
      
      msg(_("%s"),param->print(0).c_str());
      
      test (name,param);

      delete param;
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  
  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Reexecute_unit : no error");
      else
	TEST_KO("Reexecute_unit : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  delete [] _nb_inst_execute;

  return (_return);
}
