/*
 * $Id: main.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/SelfTest/include/test.h"
#include "Common/include/Max.h"

#define NB_PARAMS 20

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * size_general_data                                                                    (uint32_t             )\n"));
  err (_(" * size_special_data                                                                    (uint32_t             )\n"));
//morpheo::behavioural::custom::custom_information_t (*get_custom_information) (void),                                  
                                                                                                                        
  err (_(" * nb_thread                                                                            (uint32_t             )\n"));
  err (_(" * size_ifetch_queue                       [nb_thread]                                  (uint32_t             )\n"));
  err (_(" * nb_inst_fetch                           [nb_thread]                                  (uint32_t             )\n"));
//err (_(" * implement_group                         [nb_thread][NB_GROUP]                        (bool                 )\n"));
  err (_(" * ras_size_queue                          [nb_thread]                                  (uint32_t             )\n"));
  err (_(" * upt_size_queue                          [nb_thread]                                  (uint32_t             )\n"));
  err (_(" * ufpt_size_queue                         [nb_thread]                                  (uint32_t             )\n"));
                                                                                                                        
  err (_(" * nb_decod_bloc                                                                        (uint32_t             )\n"));
  err (_(" * size_decod_queue                        [nb_decod_bloc]                              (uint32_t             )\n"));
  err (_(" * decod_queue_scheme                      [nb_decod_bloc]                              (Tdecod_queue_scheme_t)\n"));
  err (_(" * nb_inst_decod                           [nb_decod_bloc]                              (uint32_t             )\n"));
  err (_(" * nb_context_select                       [nb_decod_bloc]                              (uint32_t             )\n"));
  err (_(" * context_select_priority                 [nb_decod_bloc]                              (Tpriority_t          )\n"));
  err (_(" * context_select_load_balancing           [nb_decod_bloc]                              (Tload_balancing_t    )\n"));
                                                                                                                        
  err (_(" * nb_rename_bloc                                                                       (uint32_t             )\n"));
  err (_(" * nb_inst_insert                          [nb_rename_bloc]                             (uint32_t             )\n"));
  err (_(" * nb_inst_retire                          [nb_rename_bloc]                             (uint32_t             )\n"));
  err (_(" * rename_select_priority                  [nb_rename_bloc]                             (Tpriority_t          )\n"));
  err (_(" * rename_select_load_balancing            [nb_rename_bloc]                             (Tload_balancing_t    )\n"));
  err (_(" * rename_select_nb_front_end_select       [nb_rename_bloc]                             (uint32_t             )\n"));
  err (_(" * nb_general_register                     [nb_rename_bloc]                             (uint32_t             )\n"));
  err (_(" * nb_special_register                     [nb_rename_bloc]                             (uint32_t             )\n"));
  err (_(" * nb_reg_free                             [nb_rename_bloc]                             (uint32_t             )\n"));
  err (_(" * nb_rename_unit_bank                     [nb_rename_bloc]                             (uint32_t             )\n"));
//   err (_(" * size_read_counter                       [nb_rename_bloc]                             (uint32_t             )\n"));
                                                                                                                        
  err (_(" * nb_read_bloc                                                                         (uint32_t             )\n"));
  err (_(" * size_read_queue                         [nb_read_bloc]                               (uint32_t             )\n"));
  err (_(" * size_reservation_station                [nb_read_bloc]                               (uint32_t             )\n"));
  err (_(" * nb_inst_retire_reservation_station      [nb_read_bloc]                               (uint32_t             )\n"));
                                                                                                                        
  err (_(" * nb_write_bloc                                                                        (uint32_t             )\n"));
  err (_(" * size_write_queue                        [nb_write_bloc]                              (uint32_t             )\n"));
  err (_(" * size_execute_queue                      [nb_write_bloc]                              (uint32_t             )\n"));
  err (_(" * nb_bypass_write                         [nb_write_bloc]                              (uint32_t             )\n"));
  err (_(" * write_queue_scheme                      [nb_write_bloc]                              (Twrite_queue_scheme_t)\n"));
                                                                                                                        
  err (_(" * nb_load_store_unit                                                                   (uint32_t             )\n"));
  err (_(" * size_store_queue                        [nb_load_store_unit]                         (uint32_t             )\n"));
  err (_(" * size_load_queue                         [nb_load_store_unit]                         (uint32_t             )\n"));
  err (_(" * size_speculative_access_queue           [nb_load_store_unit]                         (uint32_t             )\n"));
  err (_(" * nb_port_check                           [nb_load_store_unit]                         (uint32_t             )\n"));
  err (_(" * speculative_load                        [nb_load_store_unit]                         (Tspeculative_load    )\n"));
  err (_(" * nb_bypass_memory                        [nb_load_store_unit]                         (uint32_t             )\n"));
  err (_(" * nb_cache_port                           [nb_load_store_unit]                         (uint32_t             )\n"));
  err (_(" * nb_inst_memory                          [nb_load_store_unit]                         (uint32_t             )\n"));
                                                                                                                        
  err (_(" * nb_functionnal_unit                                                                  (uint32_t             )\n"));
  err (_(" * nb_inst_functionnal_unit                [nb_functionnal_unit]                        (uint32_t             )\n"));
//err (_(" * timing                                  [nb_functionnal_unit][nb_type][nb_operation] (execute_timing_t     )\n"));
                                                                                                                        
  err (_(" * nb_icache_port                                                                       (uint32_t             )\n"));
  err (_(" * icache_port_priority                                                                 (Tpriority_t          )\n"));
  err (_(" * icache_port_load_balancing                                                           (Tload_balancing_t    )\n"));
                                                                                                                        
  err (_(" * nb_dcache_port                                                                       (uint32_t             )\n"));
  err (_(" * dcache_port_priority                                                                 (Tpriority_t          )\n"));
  err (_(" * dcache_port_load_balancing                                                           (Tload_balancing_t    )\n"));
                                                                                                                        
  err (_(" * nb_front_end                                                                         (uint32_t             )\n"));
  err (_(" * nb_context                              [nb_front_end]                               (uint32_t             )\n"));
  err (_(" * nb_decod_unit                           [nb_front_end]                               (uint32_t             )\n"));
  err (_(" * nb_inst_branch_predict                  [nb_front_end]                               (uint32_t             )\n"));
  err (_(" * nb_inst_branch_decod                    [nb_front_end]                               (uint32_t             )\n"));
  err (_(" * nb_inst_branch_update                   [nb_front_end]                               (uint32_t             )\n"));
  err (_(" * btb_size_queue                          [nb_front_end]                               (uint32_t             )\n"));
  err (_(" * btb_associativity                       [nb_front_end]                               (uint32_t             )\n"));
  err (_(" * btb_size_counter                        [nb_front_end]                               (uint32_t             )\n"));
  err (_(" * btb_victim_scheme                       [nb_front_end]                               (Tvictim_t            )\n"));
  err (_(" * dir_predictor_scheme                    [nb_front_end]                               (Tpredictor_t         )\n"));
  err (_(" * dir_have_bht                            [nb_front_end][3]                            (bool                 )\n"));
  err (_(" * dir_bht_size_shifter                    [nb_front_end][3]                            (uint32_t             )\n"));
  err (_(" * dir_bht_nb_shifter                      [nb_front_end][3]                            (uint32_t             )\n"));
  err (_(" * dir_have_pht                            [nb_front_end][3]                            (bool                 )\n"));
  err (_(" * dir_pht_size_counter                    [nb_front_end][3]                            (uint32_t             )\n"));
  err (_(" * dir_pht_nb_counter                      [nb_front_end][3]                            (uint32_t             )\n"));
  err (_(" * dir_pht_size_address_share              [nb_front_end][3]                            (uint32_t             )\n"));
                                                                                                                        
  err (_(" * nb_ooo_engine                                                                        (uint32_t             )\n"));
  err (_(" * nb_rename_unit                          [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * nb_inst_issue                           [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * nb_inst_reexecute                       [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * nb_inst_commit                          [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * nb_inst_branch_complete                 [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * nb_rename_unit_select                   [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * nb_execute_loop_select                  [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * size_re_order_buffer                    [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * nb_re_order_buffer_bank                 [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * commit_priority                         [nb_ooo_engine]                              (Tpriority_t          )\n"));
  err (_(" * commit_load_balancing                   [nb_ooo_engine]                              (Tload_balancing_t    )\n"));
  err (_(" * size_issue_queue                        [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * issue_queue_scheme                      [nb_ooo_engine]                              (Tissue_queue_scheme_t)\n"));
  err (_(" * nb_issue_queue_bank                     [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * issue_priority                          [nb_ooo_engine]                              (Tpriority_t          )\n"));
  err (_(" * issue_load_balancing                    [nb_ooo_engine]                              (Tload_balancing_t    )\n"));
  err (_(" * size_reexecute_queue                    [nb_ooo_engine]                              (uint32_t             )\n"));
  err (_(" * reexecute_priority                      [nb_ooo_engine]                              (Tpriority_t          )\n"));
  err (_(" * reexecute_load_balancing                [nb_ooo_engine]                              (Tload_balancing_t    )\n"));
                                                                                                                        
  err (_(" * nb_execute_loop                                                                      (uint32_t             )\n"));
  err (_(" * nb_read_unit                            [nb_execute_loop]                            (uint32_t             )\n"));
  err (_(" * nb_execute_unit                         [nb_execute_loop]                            (uint32_t             )\n"));
  err (_(" * nb_write_unit                           [nb_execute_loop]                            (uint32_t             )\n"));
  err (_(" * nb_gpr_bank                             [nb_execute_loop]                            (uint32_t             )\n"));
  err (_(" * nb_gpr_port_read_by_bank                [nb_execute_loop]                            (uint32_t             )\n"));
  err (_(" * nb_gpr_port_write_by_bank               [nb_execute_loop]                            (uint32_t             )\n"));
  err (_(" * nb_spr_bank                             [nb_execute_loop]                            (uint32_t             )\n"));
  err (_(" * nb_spr_port_read_by_bank                [nb_execute_loop]                            (uint32_t             )\n"));
  err (_(" * nb_spr_port_write_by_bank               [nb_execute_loop]                            (uint32_t             )\n"));
  err (_(" * execution_unit_to_write_unit_priority   [nb_execute_loop]                            (Tpriority_t          )\n"));
  err (_(" * read_unit_to_execution_unit_priority    [nb_execute_loop]                            (Tpriority_t          )\n"));
                                                                                                                        
  err (_(" * link_context_with_thread                [nb_thread]                                  (pair_dual            )\n"));
  err (_(" * link_decod_unit_with_decod_bloc         [nb_decod_bloc]                              (pair_dual            )\n"));
  err (_(" * link_rename_unit_with_rename_bloc       [nb_rename_bloc]                             (pair_dual            )\n"));
  err (_(" * link_read_unit_with_read_bloc           [nb_read_bloc]                               (pair_dual            )\n"));
  err (_(" * link_write_unit_with_write_bloc         [nb_write_bloc]                              (pair_dual            )\n"));
  err (_(" * link_execute_unit_with_functionnal_unit [nb_functionnal_unit]                        (pair_dual            )\n"));
  err (_(" * link_execute_unit_with_load_store_unit  [nb_load_store_unit]                         (pair_dual            )\n"));
  err (_(" * link_decod_bloc_with_thread             [nb_thread]                                  (uint32_t             )\n"));
  err (_(" * link_rename_bloc_with_front_end         [nb_front_end]                               (uint32_t             )\n"));
  err (_(" * table_dispatch                          [nb_ooo_engine][nb_inst_issue][nb_read_bloc] (bool                 )\n"));
  err (_(" * link_read_bloc_and_load_store_unit      [nb_read_bloc][nb_load_store_unit]           (bool                 )\n"));
  err (_(" * link_read_bloc_and_functionnal_unit     [nb_read_bloc][nb_functionnal_unit]          (bool                 )\n"));
  err (_(" * link_write_bloc_and_load_store_unit     [nb_write_bloc][nb_load_store_unit]          (bool                 )\n"));
  err (_(" * link_write_bloc_and_functionnal_unit    [nb_write_bloc][nb_functionnal_unit]         (bool                 )\n"));
  err (_(" * link_load_store_unit_with_thread        [nb_thread]                                  (uint32_t             )\n"));
  err (_(" * link_thread_and_functionnal_unit        [nb_thread][nb_functionnal_unit]             (bool                 )\n"));
  err (_(" * link_icache_port_with_thread            [nb_thread]                                  (uint32_t             )\n"));
  err (_(" * link_dcache_port_with_load_store_unit   [nb_load_store_unit][nb_cache_port]          (uint32_t             )\n"));
                                                                                                                        
  err (_(" * dispatch_priority                                                                    (Tpriority_t          )\n"));
  err (_(" * dispatch_load_balancing                                                              (Tload_balancing_t    )\n"));
  err (_("\n"));
  err (_(" - pair_dual : first = x div 1000, second = x mod 1000\n"));
  err (_("\n"));
  err (_(" - now they have %d\n"),argc);

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);
  
  uint32_t x = 1;

  string name = argv[x++];

  // Common
  uint32_t                _size_general_data                             ;
  uint32_t                _size_special_data                             ;
  morpheo::behavioural::custom::custom_information_t (*_get_custom_information) (void);
    
  // Thread
  uint32_t                _nb_thread                                     ;
  uint32_t              * _size_ifetch_queue                             ;//[nb_thread]
  uint32_t              * _nb_inst_fetch                                 ;//[nb_thread]
  bool                 ** _implement_group                               ;//[nb_thread][NB_GROUP]
  uint32_t              * _ras_size_queue                                ;//[nb_thread]
  uint32_t              * _upt_size_queue                                ;//[nb_thread]
  uint32_t              * _ufpt_size_queue                               ;//[nb_thread]

  // Decod_bloc
  uint32_t                _nb_decod_bloc                                 ;//
  uint32_t              * _size_decod_queue                              ;//[nb_decod_bloc]
  multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t
                        * _decod_queue_scheme                            ;//[nb_decod_bloc]
  uint32_t              * _nb_inst_decod                                 ;//[nb_decod_bloc]
  uint32_t              * _nb_context_select                             ;//[nb_decod_bloc]
  Tpriority_t           * _context_select_priority                       ;//[nb_decod_bloc]
  Tload_balancing_t     * _context_select_load_balancing                 ;//[nb_decod_bloc]

  // Rename_bloc
  uint32_t                _nb_rename_bloc                                ;//
  uint32_t              * _nb_inst_insert                                ;//[nb_rename_bloc]
  uint32_t              * _nb_inst_retire                                ;//[nb_rename_bloc]
  Tpriority_t           * _rename_select_priority                        ;//[nb_rename_bloc]
  Tload_balancing_t     * _rename_select_load_balancing                  ;//[nb_rename_bloc]
  uint32_t              * _rename_select_nb_front_end_select             ;//[nb_rename_bloc]
  uint32_t              * _nb_general_register                           ;//[nb_rename_bloc]
  uint32_t              * _nb_special_register                           ;//[nb_rename_bloc]
  uint32_t              * _nb_reg_free                                   ;//[nb_rename_bloc]
  uint32_t              * _nb_rename_unit_bank                           ;//[nb_rename_bloc]
//   uint32_t              * _size_read_counter                             ;//[nb_rename_bloc]

  // Read bloc
  uint32_t                _nb_read_bloc                                  ;//
  uint32_t              * _size_read_queue                               ;//[nb_read_bloc]
  uint32_t              * _size_reservation_station                      ;//[nb_read_bloc]
  uint32_t              * _nb_inst_retire_reservation_station            ;//[nb_read_bloc]
  
  // Write bloc
  uint32_t                _nb_write_bloc                                 ;//
  uint32_t              * _size_write_queue                              ;//[nb_write_bloc]
  uint32_t              * _size_execute_queue                            ;//[nb_write_bloc]
  uint32_t              * _nb_bypass_write                               ;//[nb_write_bloc]
  core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t * _write_queue_scheme; //[nb_write_bloc]

  // Load_store_unit
  uint32_t                _nb_load_store_unit                            ;
  uint32_t              * _size_store_queue                              ;//[nb_load_store_unit]
  uint32_t              * _size_load_queue                               ;//[nb_load_store_unit]
  uint32_t              * _size_speculative_access_queue                 ;//[nb_load_store_unit]
  uint32_t              * _nb_port_check                                 ;//[nb_load_store_unit]
  multi_execute_loop::execute_loop::Tspeculative_load_t  
                        * _speculative_load                              ;//[nb_load_store_unit]
  uint32_t              * _nb_bypass_memory                              ;//[nb_load_store_unit]
  uint32_t              * _nb_cache_port                                 ;//[nb_load_store_unit]
  uint32_t              * _nb_inst_memory                                ;//[nb_load_store_unit]

  // Functionnal_unit
  uint32_t                _nb_functionnal_unit                           ;
  uint32_t              * _nb_inst_functionnal_unit                      ;//[nb_functionnal_unit]
  multi_execute_loop::execute_loop::execute_timing_t
                      *** _timing                                        ;//[nb_functionnal_unit][nb_type][nb_operation]

  // Icache_Access
  uint32_t                _nb_icache_port                                ;
  Tpriority_t             _icache_port_priority                          ;
  Tload_balancing_t       _icache_port_load_balancing                    ;

  // Dcache_Access
  uint32_t                _nb_dcache_port                                ;
  Tpriority_t             _dcache_port_priority                          ;
  Tload_balancing_t       _dcache_port_load_balancing                    ;

  // Front_end
  uint32_t                _nb_front_end                                  ;
  uint32_t              * _nb_context                                    ;//[nb_front_end]
  uint32_t              * _nb_decod_unit                                 ;//[nb_front_end]
  uint32_t              * _nb_inst_branch_predict                        ;//[nb_front_end]
  uint32_t              * _nb_inst_branch_decod                          ;//[nb_front_end]
  uint32_t              * _nb_inst_branch_update                         ;//[nb_front_end]
  uint32_t              * _btb_size_queue                                ;//[nb_front_end]
  uint32_t              * _btb_associativity                             ;//[nb_front_end]
  uint32_t              * _btb_size_counter                              ;//[nb_front_end]
  Tvictim_t             * _btb_victim_scheme                             ;//[nb_front_end]
  Tpredictor_t          * _dir_predictor_scheme                          ;//[nb_front_end]
  bool                 ** _dir_have_bht                                  ;//[nb_front_end][3]
  uint32_t             ** _dir_bht_size_shifter                          ;//[nb_front_end][3]
  uint32_t             ** _dir_bht_nb_shifter                            ;//[nb_front_end][3]
  bool                 ** _dir_have_pht                                  ;//[nb_front_end][3]
  uint32_t             ** _dir_pht_size_counter                          ;//[nb_front_end][3]
  uint32_t             ** _dir_pht_nb_counter                            ;//[nb_front_end][3]
  uint32_t             ** _dir_pht_size_address_share                    ;//[nb_front_end][3]

  // OOO_Engine
  uint32_t                _nb_ooo_engine                                 ;
  uint32_t              * _nb_rename_unit                                ;//[nb_ooo_engine]
  uint32_t              * _nb_inst_issue                                 ;//[nb_ooo_engine]
  uint32_t              * _nb_inst_reexecute                             ;//[nb_ooo_engine]
  uint32_t              * _nb_inst_commit                                ;//[nb_ooo_engine]
  uint32_t              * _nb_inst_branch_complete                       ;//[nb_ooo_engine]
  uint32_t              * _nb_rename_unit_select                         ;//[nb_ooo_engine]
  uint32_t              * _nb_execute_loop_select                        ;//[nb_ooo_engine]
  uint32_t              * _size_re_order_buffer                          ;//[nb_ooo_engine]
  uint32_t              * _nb_re_order_buffer_bank                       ;//[nb_ooo_engine]
  Tpriority_t           * _commit_priority                               ;//[nb_ooo_engine]
  Tload_balancing_t     * _commit_load_balancing                         ;//[nb_ooo_engine]
  uint32_t              * _size_issue_queue                              ;//[nb_ooo_engine]
  multi_ooo_engine::ooo_engine::issue_queue::Tissue_queue_scheme_t
                        * _issue_queue_scheme                            ;//[nb_ooo_engine]
  uint32_t              * _nb_issue_queue_bank                           ;//[nb_ooo_engine]
  Tpriority_t           * _issue_priority                                ;//[nb_ooo_engine]
  Tload_balancing_t     * _issue_load_balancing                          ;//[nb_ooo_engine]
  uint32_t              * _size_reexecute_queue                          ;//[nb_ooo_engine]
  Tpriority_t           * _reexecute_priority                            ;//[nb_ooo_engine]
  Tload_balancing_t     * _reexecute_load_balancing                      ;//[nb_ooo_engine]

  // Execute_loop
  uint32_t                _nb_execute_loop                               ;
  uint32_t              * _nb_read_unit                                  ;//[nb_execute_loop]
  uint32_t              * _nb_execute_unit                               ;//[nb_execute_loop]
  uint32_t              * _nb_write_unit                                 ;//[nb_execute_loop]
  uint32_t              * _nb_gpr_bank                                   ;//[nb_execute_loop]
  uint32_t              * _nb_gpr_port_read_by_bank                      ;//[nb_execute_loop]
  uint32_t              * _nb_gpr_port_write_by_bank                     ;//[nb_execute_loop]
  uint32_t              * _nb_spr_bank                                   ;//[nb_execute_loop]
  uint32_t              * _nb_spr_port_read_by_bank                      ;//[nb_execute_loop]
  uint32_t              * _nb_spr_port_write_by_bank                     ;//[nb_execute_loop]
  Tpriority_t           * _execution_unit_to_write_unit_priority         ;//[nb_execute_loop]
  Tpriority_t           * _read_unit_to_execution_unit_priority          ;//[nb_execute_loop]

  // Link
  pair_dual             * _link_context_with_thread                      ;//[nb_thread]
  pair_dual             * _link_decod_unit_with_decod_bloc               ;//[nb_decod_bloc]
  pair_dual             * _link_rename_unit_with_rename_bloc             ;//[nb_rename_bloc]
  pair_dual             * _link_read_unit_with_read_bloc                 ;//[nb_read_bloc]
  pair_dual             * _link_write_unit_with_write_bloc               ;//[nb_write_bloc]
  pair_dual             * _link_execute_unit_with_functionnal_unit       ;//[nb_functionnal_unit]
  pair_dual             * _link_execute_unit_with_load_store_unit        ;//[nb_load_store_unit]
  uint32_t              * _link_decod_bloc_with_thread                   ;//[nb_thread]
  uint32_t              * _link_rename_bloc_with_front_end               ;//[nb_front_end]
  bool                *** _table_dispatch                                ;//[nb_ooo_engine][nb_inst_issue][nb_read_bloc]
  bool                 ** _link_read_bloc_and_load_store_unit            ;//[nb_read_bloc][nb_load_store_unit]
  bool                 ** _link_read_bloc_and_functionnal_unit           ;//[nb_read_bloc][nb_functionnal_unit]
  bool                 ** _link_write_bloc_and_load_store_unit           ;//[nb_write_bloc][nb_load_store_unit]
  bool                 ** _link_write_bloc_and_functionnal_unit          ;//[nb_write_bloc][nb_functionnal_unit]
  uint32_t              * _link_load_store_unit_with_thread              ;//[nb_thread]                    
  bool                 ** _link_thread_and_functionnal_unit              ;//[nb_thread][nb_functionnal_unit]
  uint32_t              * _link_icache_port_with_thread                  ;//[nb_thread]
  uint32_t             ** _link_dcache_port_with_load_store_unit         ;//[nb_load_store_unit][nb_cache_port]  

  Tpriority_t             _dispatch_priority                             ;
  Tload_balancing_t       _dispatch_load_balancing                       ;

  printf("Core parameters :\n");

  // Common
  printf(" * Common\n");
  SELFTEST0(_size_general_data                             ,uint32_t                ,argv,x);
  SELFTEST0(_size_special_data                             ,uint32_t                ,argv,x);
  _get_custom_information = &(morpheo::behavioural::custom::default_get_custom_information);

  //Thread
  printf(" * Thread\n");
  SELFTEST0(_nb_thread                                     ,uint32_t                ,argv,x);

  if (argc < static_cast<int>(2+NB_PARAMS+5*_nb_thread))
    usage (argc, argv);
  
  SELFTEST1(_size_ifetch_queue                             ,uint32_t                ,argv,x,_nb_thread);
  SELFTEST1(_nb_inst_fetch                                 ,uint32_t                ,argv,x,_nb_thread);
  ALLOC2   (_implement_group                               ,bool                           ,_nb_thread,NB_GROUP);
  for (uint32_t i=0; i<_nb_thread; ++i)
    for (uint32_t j=0; j<NB_GROUP; ++j)
      _implement_group[i][j] = true;  
  SELFTEST1(_ras_size_queue                                ,uint32_t                ,argv,x,_nb_thread);
  SELFTEST1(_upt_size_queue                                ,uint32_t                ,argv,x,_nb_thread);
  SELFTEST1(_ufpt_size_queue                               ,uint32_t                ,argv,x,_nb_thread);

  // Decod bloc
  printf(" * Decod bloc\n");
  SELFTEST0(_nb_decod_bloc                                 ,uint32_t                ,argv,x);

  if (argc < static_cast<int>(2+NB_PARAMS+5*_nb_thread+6*_nb_decod_bloc))
    usage (argc, argv);
  
  SELFTEST1(_size_decod_queue                              ,uint32_t                ,argv,x,_nb_decod_bloc);
  SELFTEST1(_decod_queue_scheme                            ,multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t,argv,x,_nb_decod_bloc);
  SELFTEST1(_nb_inst_decod                                 ,uint32_t                ,argv,x,_nb_decod_bloc);
  SELFTEST1(_nb_context_select                             ,uint32_t                ,argv,x,_nb_decod_bloc);
  SELFTEST1(_context_select_priority                       ,Tpriority_t             ,argv,x,_nb_decod_bloc);
  SELFTEST1(_context_select_load_balancing                 ,Tload_balancing_t       ,argv,x,_nb_decod_bloc);

  // Rename bloc
  printf(" * Rename bloc\n");
  SELFTEST0(_nb_rename_bloc                                ,uint32_t                ,argv,x);

  if (argc < static_cast<int>(2+NB_PARAMS+5*_nb_thread+6*_nb_decod_bloc+9*_nb_rename_bloc))
    usage (argc, argv);
  
  SELFTEST1(_nb_inst_insert                                ,uint32_t                ,argv,x,_nb_rename_bloc);
  SELFTEST1(_nb_inst_retire                                ,uint32_t                ,argv,x,_nb_rename_bloc);
  SELFTEST1(_rename_select_priority                        ,Tpriority_t             ,argv,x,_nb_rename_bloc);
  SELFTEST1(_rename_select_load_balancing                  ,Tload_balancing_t       ,argv,x,_nb_rename_bloc);
  SELFTEST1(_rename_select_nb_front_end_select             ,uint32_t                ,argv,x,_nb_rename_bloc);
  SELFTEST1(_nb_general_register                           ,uint32_t                ,argv,x,_nb_rename_bloc);
  SELFTEST1(_nb_special_register                           ,uint32_t                ,argv,x,_nb_rename_bloc);
  SELFTEST1(_nb_reg_free                                   ,uint32_t                ,argv,x,_nb_rename_bloc);
  SELFTEST1(_nb_rename_unit_bank                           ,uint32_t                ,argv,x,_nb_rename_bloc);
//   SELFTEST1(_size_read_counter                             ,uint32_t                ,argv,x,_nb_rename_bloc);

  // Read bloc
  printf(" * Read bloc\n");
  SELFTEST0(_nb_read_bloc                                  ,uint32_t                ,argv,x);

  if (argc < static_cast<int>(2+NB_PARAMS+5*_nb_thread+6*_nb_decod_bloc+9*_nb_rename_bloc+3*_nb_read_bloc))
    usage (argc, argv);
  
  SELFTEST1(_size_read_queue                               ,uint32_t                ,argv,x,_nb_read_bloc);
  SELFTEST1(_size_reservation_station                      ,uint32_t                ,argv,x,_nb_read_bloc);
  SELFTEST1(_nb_inst_retire_reservation_station            ,uint32_t                ,argv,x,_nb_read_bloc);

  // Write bloc
  printf(" * Write bloc\n");
  SELFTEST0(_nb_write_bloc                                 ,uint32_t                ,argv,x);

  if (argc < static_cast<int>(2+NB_PARAMS+5*_nb_thread+6*_nb_decod_bloc+9*_nb_rename_bloc+3*_nb_read_bloc+4*_nb_write_bloc))
    usage (argc, argv);
  
  SELFTEST1(_size_write_queue                              ,uint32_t                ,argv,x,_nb_write_bloc);
  SELFTEST1(_size_execute_queue                            ,uint32_t                ,argv,x,_nb_write_bloc);
  SELFTEST1(_nb_bypass_write                               ,uint32_t                ,argv,x,_nb_write_bloc);
  SELFTEST1(_write_queue_scheme,core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t,argv,x,_nb_write_bloc);

  // Load store unit
  printf(" * Load store unit\n");
  SELFTEST0(_nb_load_store_unit                            ,uint32_t                ,argv,x);

  if (argc < static_cast<int>(2+NB_PARAMS+5*_nb_thread+6*_nb_decod_bloc+9*_nb_rename_bloc+3*_nb_read_bloc+4*_nb_write_bloc+8*_nb_load_store_unit))
    usage (argc, argv);
  
  SELFTEST1(_size_store_queue                              ,uint32_t                ,argv,x,_nb_load_store_unit);
  SELFTEST1(_size_load_queue                               ,uint32_t                ,argv,x,_nb_load_store_unit);
  SELFTEST1(_size_speculative_access_queue                 ,uint32_t                ,argv,x,_nb_load_store_unit);
  SELFTEST1(_nb_port_check                                 ,uint32_t                ,argv,x,_nb_load_store_unit);
  SELFTEST1(_speculative_load                              ,multi_execute_loop::execute_loop::Tspeculative_load_t
                                                                                    ,argv,x,_nb_load_store_unit);
  SELFTEST1(_nb_bypass_memory                              ,uint32_t                ,argv,x,_nb_load_store_unit);
  SELFTEST1(_nb_cache_port                                 ,uint32_t                ,argv,x,_nb_load_store_unit);
  SELFTEST1(_nb_inst_memory                                ,uint32_t                ,argv,x,_nb_load_store_unit);

  // Functionnal_unit
  printf(" * Functional unit\n");
  SELFTEST0(_nb_functionnal_unit                           ,uint32_t                ,argv,x);

  if (argc < static_cast<int>(2+NB_PARAMS+5*_nb_thread+6*_nb_decod_bloc+9*_nb_rename_bloc+3*_nb_read_bloc+4*_nb_write_bloc+8*_nb_load_store_unit+1*_nb_functionnal_unit))
    usage (argc, argv);
  
  SELFTEST1(_nb_inst_functionnal_unit                      ,uint32_t                ,argv,x,_nb_functionnal_unit);
  ALLOC3   (_timing                                        ,multi_execute_loop::execute_loop::execute_timing_t,_nb_functionnal_unit,MAX_TYPE,MAX_OPERATION);

  for (uint32_t i=0; i< _nb_functionnal_unit; i++)
    for (uint32_t j=0; j< MAX_TYPE; j++)
      if ((j == TYPE_ALU    ) |
          (j == TYPE_SHIFT  ) |
          (j == TYPE_MOVE   ) |
          (j == TYPE_TEST   ) |
          (j == TYPE_MUL    ) |
          (j == TYPE_DIV    ) |
          (j == TYPE_EXTEND ) |
          (j == TYPE_FIND   ) |
          (j == TYPE_SPECIAL) |
          (j == TYPE_CUSTOM ) |
          (j == TYPE_BRANCH ) // |
//        (j == TYPE_MEMORY ) 
          )
        for (uint32_t k=0; k< MAX_OPERATION; k++)
          _timing [i][j][k]._delay = _timing [i][j][k]._latence = 1;

  // Icache_Access
  printf(" * Icache access\n");
  
  SELFTEST0(_nb_icache_port                                ,uint32_t                ,argv,x);
  SELFTEST0(_icache_port_priority                          ,Tpriority_t             ,argv,x);
  SELFTEST0(_icache_port_load_balancing                    ,Tload_balancing_t       ,argv,x);

  // Dcache_Access
  printf(" * Dcache access\n");

  SELFTEST0(_nb_dcache_port                                ,uint32_t                ,argv,x);
  SELFTEST0(_dcache_port_priority                          ,Tpriority_t             ,argv,x);
  SELFTEST0(_dcache_port_load_balancing                    ,Tload_balancing_t       ,argv,x);

  // Front_end
  printf(" * Front end\n");

  SELFTEST0(_nb_front_end                                  ,uint32_t                ,argv,x);

  if (argc < static_cast<int>(2+NB_PARAMS+5*_nb_thread+6*_nb_decod_bloc+9*_nb_rename_bloc+3*_nb_read_bloc+4*_nb_write_bloc+8*_nb_load_store_unit+1*_nb_functionnal_unit+31*_nb_front_end))
    usage (argc, argv);
  
  SELFTEST1(_nb_context                                    ,uint32_t                ,argv,x,_nb_front_end);
  SELFTEST1(_nb_decod_unit                                 ,uint32_t                ,argv,x,_nb_front_end);
  SELFTEST1(_nb_inst_branch_predict                        ,uint32_t                ,argv,x,_nb_front_end);
  SELFTEST1(_nb_inst_branch_decod                          ,uint32_t                ,argv,x,_nb_front_end);
  SELFTEST1(_nb_inst_branch_update                         ,uint32_t                ,argv,x,_nb_front_end);
  SELFTEST1(_btb_size_queue                                ,uint32_t                ,argv,x,_nb_front_end);
  SELFTEST1(_btb_associativity                             ,uint32_t                ,argv,x,_nb_front_end);
  SELFTEST1(_btb_size_counter                              ,uint32_t                ,argv,x,_nb_front_end);
  SELFTEST1(_btb_victim_scheme                             ,Tvictim_t               ,argv,x,_nb_front_end);
  SELFTEST1(_dir_predictor_scheme                          ,Tpredictor_t            ,argv,x,_nb_front_end);

  SELFTEST2(_dir_have_bht                                  ,bool                    ,argv,x,_nb_front_end,3);
  SELFTEST2(_dir_bht_size_shifter                          ,uint32_t                ,argv,x,_nb_front_end,3);
  SELFTEST2(_dir_bht_nb_shifter                            ,uint32_t                ,argv,x,_nb_front_end,3);
  SELFTEST2(_dir_have_pht                                  ,bool                    ,argv,x,_nb_front_end,3);
  SELFTEST2(_dir_pht_size_counter                          ,uint32_t                ,argv,x,_nb_front_end,3);
  SELFTEST2(_dir_pht_nb_counter                            ,uint32_t                ,argv,x,_nb_front_end,3);
  SELFTEST2(_dir_pht_size_address_share                    ,uint32_t                ,argv,x,_nb_front_end,3);

  // OOO_Engine
  printf(" * OOO Engine\n");

  SELFTEST0(_nb_ooo_engine                                 ,uint32_t                ,argv,x);
  
  if (argc < static_cast<int>(2+NB_PARAMS+5*_nb_thread+6*_nb_decod_bloc+9*_nb_rename_bloc+3*_nb_read_bloc+4*_nb_write_bloc+8*_nb_load_store_unit+1*_nb_functionnal_unit+31*_nb_front_end+19*_nb_ooo_engine))
    usage (argc, argv);
  
  SELFTEST1(_nb_rename_unit                                ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_nb_inst_issue                                 ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_nb_inst_reexecute                             ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_nb_inst_commit                                ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_nb_inst_branch_complete                       ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_nb_rename_unit_select                         ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_nb_execute_loop_select                        ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_size_re_order_buffer                          ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_nb_re_order_buffer_bank                       ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_commit_priority                               ,Tpriority_t             ,argv,x,_nb_ooo_engine);
  SELFTEST1(_commit_load_balancing                         ,Tload_balancing_t       ,argv,x,_nb_ooo_engine);
  SELFTEST1(_size_issue_queue                              ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_issue_queue_scheme                            ,multi_ooo_engine::ooo_engine::issue_queue::Tissue_queue_scheme_t,argv,x,_nb_ooo_engine);
  SELFTEST1(_nb_issue_queue_bank                           ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_issue_priority                                ,Tpriority_t             ,argv,x,_nb_ooo_engine);
  SELFTEST1(_issue_load_balancing                          ,Tload_balancing_t       ,argv,x,_nb_ooo_engine);
  SELFTEST1(_size_reexecute_queue                          ,uint32_t                ,argv,x,_nb_ooo_engine);
  SELFTEST1(_reexecute_priority                            ,Tpriority_t             ,argv,x,_nb_ooo_engine);
  SELFTEST1(_reexecute_load_balancing                      ,Tload_balancing_t       ,argv,x,_nb_ooo_engine);

  //Execute_loop
  printf(" * Execute Loop\n");

  SELFTEST0(_nb_execute_loop                               ,uint32_t                ,argv,x);

  if (argc < static_cast<int>(2+NB_PARAMS+5*_nb_thread+6*_nb_decod_bloc+9*_nb_rename_bloc+3*_nb_read_bloc+4*_nb_write_bloc+8*_nb_load_store_unit+1*_nb_functionnal_unit+31*_nb_front_end+19*_nb_ooo_engine+11*_nb_execute_loop))
    usage (argc, argv);
  
  SELFTEST1(_nb_read_unit                                  ,uint32_t                ,argv,x,_nb_execute_loop);
  SELFTEST1(_nb_execute_unit                               ,uint32_t                ,argv,x,_nb_execute_loop);
  SELFTEST1(_nb_write_unit                                 ,uint32_t                ,argv,x,_nb_execute_loop);
  SELFTEST1(_nb_gpr_bank                                   ,uint32_t                ,argv,x,_nb_execute_loop);
  SELFTEST1(_nb_gpr_port_read_by_bank                      ,uint32_t                ,argv,x,_nb_execute_loop);
  SELFTEST1(_nb_gpr_port_write_by_bank                     ,uint32_t                ,argv,x,_nb_execute_loop);
  SELFTEST1(_nb_spr_bank                                   ,uint32_t                ,argv,x,_nb_execute_loop);
  SELFTEST1(_nb_spr_port_read_by_bank                      ,uint32_t                ,argv,x,_nb_execute_loop);
  SELFTEST1(_nb_spr_port_write_by_bank                     ,uint32_t                ,argv,x,_nb_execute_loop);
  SELFTEST1(_execution_unit_to_write_unit_priority         ,Tpriority_t             ,argv,x,_nb_execute_loop);
  SELFTEST1(_read_unit_to_execution_unit_priority          ,Tpriority_t             ,argv,x,_nb_execute_loop);
  
  // Link
  printf(" * Link\n");

  if (argc < static_cast<int>(2+NB_PARAMS+6*_nb_thread+6*_nb_decod_bloc+10*_nb_rename_bloc+4*_nb_read_bloc+5*_nb_write_bloc+9*_nb_load_store_unit+2*_nb_functionnal_unit+31*_nb_front_end+19*_nb_ooo_engine+11*_nb_execute_loop))
    usage (argc, argv);
  
  ALLOC1   (_link_context_with_thread                      ,pair_dual                      ,_nb_thread);
  ALLOC1   (_link_decod_unit_with_decod_bloc               ,pair_dual                      ,_nb_decod_bloc);
  ALLOC1   (_link_rename_unit_with_rename_bloc             ,pair_dual                      ,_nb_rename_bloc);
  ALLOC1   (_link_read_unit_with_read_bloc                 ,pair_dual                      ,_nb_read_bloc);
  ALLOC1   (_link_write_unit_with_write_bloc               ,pair_dual                      ,_nb_write_bloc);
  ALLOC1   (_link_execute_unit_with_functionnal_unit       ,pair_dual                      ,_nb_functionnal_unit);
  ALLOC1   (_link_execute_unit_with_load_store_unit        ,pair_dual                      ,_nb_load_store_unit);
  
  for (uint32_t i=0; i<_nb_thread; ++i)
    {
      uint32_t tmp=fromString<uint32_t>(argv[x++]);
      _link_context_with_thread                [i] = pair_dual(tmp/1000,tmp%1000);
    }
  for (uint32_t i=0; i<_nb_decod_bloc; ++i)
    {
      uint32_t tmp=fromString<uint32_t>(argv[x++]);
      _link_decod_unit_with_decod_bloc         [i] = pair_dual(tmp/1000,tmp%1000);
    }
  for (uint32_t i=0; i<_nb_rename_bloc; ++i)
    {
      uint32_t tmp=fromString<uint32_t>(argv[x++]);
      _link_rename_unit_with_rename_bloc       [i] = pair_dual(tmp/1000,tmp%1000);
    }
  for (uint32_t i=0; i<_nb_read_bloc; ++i)
    {
      uint32_t tmp=fromString<uint32_t>(argv[x++]);
      _link_read_unit_with_read_bloc           [i] = pair_dual(tmp/1000,tmp%1000);
    }
  for (uint32_t i=0; i<_nb_write_bloc; ++i)
    {
      uint32_t tmp=fromString<uint32_t>(argv[x++]);
      _link_write_unit_with_write_bloc         [i] = pair_dual(tmp/1000,tmp%1000);
    }
  for (uint32_t i=0; i<_nb_functionnal_unit; ++i)
    {
      uint32_t tmp=fromString<uint32_t>(argv[x++]);
      _link_execute_unit_with_functionnal_unit [i] = pair_dual(tmp/1000,tmp%1000);
    }
  for (uint32_t i=0; i<_nb_load_store_unit; ++i)
    {
      uint32_t tmp=fromString<uint32_t>(argv[x++]);
      _link_execute_unit_with_load_store_unit  [i] = pair_dual(tmp/1000,tmp%1000);
    }

  uint32_t _sum_inst_issue = 0;
  for (uint32_t i=0; i<_nb_ooo_engine;++i)
    _sum_inst_issue += _nb_inst_issue[i];
  uint32_t _sum_cache_port = 0;
  for (uint32_t i=0; i<_nb_load_store_unit;++i)
    _sum_cache_port += _nb_cache_port[i];
  
  if (argc != static_cast<int>(2+NB_PARAMS+6*_nb_thread+6*_nb_decod_bloc+10*_nb_rename_bloc+4*_nb_read_bloc+5*_nb_write_bloc+9*_nb_load_store_unit+2*_nb_functionnal_unit+31*_nb_front_end+19*_nb_ooo_engine+11*_nb_execute_loop+
                               3*_nb_thread+_nb_front_end+_sum_inst_issue*_nb_read_bloc+_nb_load_store_unit*(_nb_read_bloc+_nb_write_bloc+_nb_thread)+_nb_functionnal_unit*(_nb_read_bloc+_nb_write_bloc)+_sum_cache_port))
    usage (argc, argv);
  
  SELFTEST1(_link_decod_bloc_with_thread                   ,uint32_t                ,argv,x,_nb_thread);
  SELFTEST1(_link_rename_bloc_with_front_end               ,uint32_t                ,argv,x,_nb_front_end);
  SELFTEST3(_table_dispatch                                ,bool                    ,argv,x,_nb_ooo_engine,_nb_inst_issue[it1],_nb_read_bloc);
  SELFTEST2(_link_read_bloc_and_load_store_unit            ,bool                    ,argv,x,_nb_read_bloc,_nb_load_store_unit);
  SELFTEST2(_link_read_bloc_and_functionnal_unit           ,bool                    ,argv,x,_nb_read_bloc,_nb_functionnal_unit);
  SELFTEST2(_link_write_bloc_and_load_store_unit           ,bool                    ,argv,x,_nb_write_bloc,_nb_load_store_unit);
  SELFTEST2(_link_write_bloc_and_functionnal_unit          ,bool                    ,argv,x,_nb_write_bloc,_nb_functionnal_unit);
  SELFTEST1(_link_load_store_unit_with_thread              ,uint32_t                ,argv,x,_nb_thread);
  SELFTEST2(_link_thread_and_functionnal_unit              ,bool                    ,argv,x,_nb_thread,_nb_functionnal_unit);
  SELFTEST1(_link_icache_port_with_thread                  ,uint32_t                ,argv,x,_nb_thread);
  SELFTEST2(_link_dcache_port_with_load_store_unit         ,uint32_t                ,argv,x,_nb_load_store_unit,_nb_cache_port[it1]);
  SELFTEST0(_dispatch_priority                             ,Tpriority_t             ,argv,x);
  SELFTEST0(_dispatch_load_balancing                       ,Tload_balancing_t       ,argv,x);

  printf(" * End parameters\n");
  printf("--------------------------------\n");

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::Parameters * param = new morpheo::behavioural::core::Parameters
	(
         _size_general_data                             ,
         _size_special_data                             ,
         _get_custom_information                        ,

         _nb_thread                                     ,
         _size_ifetch_queue                             ,
         _nb_inst_fetch                                 ,
         _implement_group                               ,
         _ras_size_queue                                ,
         _upt_size_queue                                ,
         _ufpt_size_queue                               ,

         _nb_decod_bloc                                 ,
         _size_decod_queue                              ,
         _decod_queue_scheme                            ,
         _nb_inst_decod                                 ,
         _nb_context_select                             ,
         _context_select_priority                       ,
         _context_select_load_balancing                 ,

         _nb_rename_bloc                                ,
         _nb_inst_insert                                ,
         _nb_inst_retire                                ,
         _rename_select_priority                        ,
         _rename_select_load_balancing                  ,
         _rename_select_nb_front_end_select             ,
         _nb_general_register                           ,
         _nb_special_register                           ,
         _nb_reg_free                                   ,
         _nb_rename_unit_bank                           ,
//          _size_read_counter                             ,

         _nb_read_bloc                                  ,
         _size_read_queue                               ,
         _size_reservation_station                      ,
         _nb_inst_retire_reservation_station            ,

         _nb_write_bloc                                 ,
         _size_write_queue                              ,
         _size_execute_queue                            ,
         _nb_bypass_write                               ,
	 _write_queue_scheme                            ,

         _nb_load_store_unit                            ,
         _size_store_queue                              ,
         _size_load_queue                               ,
         _size_speculative_access_queue                 ,
         _nb_port_check                                 ,
         _speculative_load                              ,
         _nb_bypass_memory                              ,
         _nb_cache_port                                 ,
         _nb_inst_memory                                ,

         _nb_functionnal_unit                           ,
         _nb_inst_functionnal_unit                      ,
         _timing                                        ,

         _nb_icache_port                                ,
         _icache_port_priority                          ,
         _icache_port_load_balancing                    ,

         _nb_dcache_port                                ,
         _dcache_port_priority                          ,
         _dcache_port_load_balancing                    ,

         _nb_front_end                                  ,
         _nb_context                                    ,
         _nb_decod_unit                                 ,
         _nb_inst_branch_predict                        ,
         _nb_inst_branch_decod                          ,
         _nb_inst_branch_update                         ,
         _btb_size_queue                                ,
         _btb_associativity                             ,
         _btb_size_counter                              ,
         _btb_victim_scheme                             ,
         _dir_predictor_scheme                          ,
         _dir_have_bht                                  ,
         _dir_bht_size_shifter                          ,
         _dir_bht_nb_shifter                            ,
         _dir_have_pht                                  ,
         _dir_pht_size_counter                          ,
         _dir_pht_nb_counter                            ,
         _dir_pht_size_address_share                    ,

         _nb_ooo_engine                                 ,
         _nb_rename_unit                                ,
         _nb_inst_issue                                 ,
         _nb_inst_reexecute                             ,
         _nb_inst_commit                                ,
         _nb_inst_branch_complete                       ,
         _nb_rename_unit_select                         ,
         _nb_execute_loop_select                        ,
         _size_re_order_buffer                          ,
         _nb_re_order_buffer_bank                       ,
         _commit_priority                               ,
         _commit_load_balancing                         ,
         _size_issue_queue                              ,
         _issue_queue_scheme                            ,
         _nb_issue_queue_bank                           ,
         _issue_priority                                ,
         _issue_load_balancing                          ,
         _size_reexecute_queue                          ,
         _reexecute_priority                            ,
         _reexecute_load_balancing                      ,

         _nb_execute_loop                               ,
         _nb_read_unit                                  ,
         _nb_execute_unit                               ,
         _nb_write_unit                                 ,
         _nb_gpr_bank                                   ,
         _nb_gpr_port_read_by_bank                      ,
         _nb_gpr_port_write_by_bank                     ,
         _nb_spr_bank                                   ,
         _nb_spr_port_read_by_bank                      ,
         _nb_spr_port_write_by_bank                     ,
         _execution_unit_to_write_unit_priority         ,
         _read_unit_to_execution_unit_priority          ,

         _link_context_with_thread                      ,
         _link_decod_unit_with_decod_bloc               ,
         _link_rename_unit_with_rename_bloc             ,
         _link_read_unit_with_read_bloc                 ,
         _link_write_unit_with_write_bloc               ,
         _link_execute_unit_with_functionnal_unit       ,
         _link_execute_unit_with_load_store_unit        ,
         _link_decod_bloc_with_thread                   ,
         _link_rename_bloc_with_front_end               ,
         _table_dispatch                                ,
         _link_read_bloc_and_load_store_unit            ,
         _link_read_bloc_and_functionnal_unit           ,
         _link_write_bloc_and_load_store_unit           ,
         _link_write_bloc_and_functionnal_unit          ,
         _link_load_store_unit_with_thread              ,
         _link_thread_and_functionnal_unit              ,
         _link_icache_port_with_thread                  ,
         _link_dcache_port_with_load_store_unit         ,

         _dispatch_priority                             ,
         _dispatch_load_balancing                       ,
         true // is_toplevel
         );
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Core : no error");
      else
	TEST_KO("Core : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
