/*
 * $Id: RegisterFile_Internal_Banked.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Internal_Banked/include/RegisterFile_Internal_Banked.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_internal_banked    {

  RegisterFile_Internal_Banked::RegisterFile_Internal_Banked 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   std::string name        ,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics            * param_statistics,
#endif
   morpheo::behavioural::generic::registerfile::registerfile_internal_banked::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name  (name),
    _param (param),
    _usage (usage)
  {
    log_printf(FUNC,RegisterFile_Internal_Banked,"RegisterFile_Internal_Banked","Begin");

// #if DEBUG_RegisterFile_Internal_Banked == true
//     log_printf(INFO,RegisterFile_Internal_Banked,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,RegisterFile_Internal_Banked,"RegisterFile_Internal_Banked","Allocation");
    allocation ();

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      statistics_declaration(param_statistics);
#endif

#ifdef VHDL
    // generate the vhdl
    if (usage_is_set(_usage,USE_VHDL))
      vhdl();
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {

# ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
	SC_METHOD (constant);
// 	dont_initialize ();
#endif

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();

	SC_METHOD (genMealy_read);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg()
		  << (*(in_NRESET));

	for (uint32_t i=0; i<_param->_nb_port_read; i++)
	  {
	    sensitive << *(in_READ_VAL     [i]);
	    if (_param->_have_port_address)
	      sensitive << *(in_READ_ADDRESS [i]);
	  }
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_port_read; i++)
	  {
	    (*(out_READ_DATA  [i])) (*( in_READ_VAL     [i]));
	    if (_param->_have_port_address)
	      (*(out_READ_DATA  [i])) (*( in_READ_ADDRESS [i]));
	  }
# endif    
      }
#endif
    
    log_printf(FUNC,RegisterFile_Internal_Banked,"RegisterFile_Internal_Banked","End");
  };
  
  RegisterFile_Internal_Banked::~RegisterFile_Internal_Banked (void)
  {
#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      delete _stat;
#endif

    deallocation ();
  };

}; // end namespace registerfile_internal_banked
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
