#ifdef VHDL
/*
 * $Id: RegisterFile_Internal_Banked_vhdl_body.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Internal_Banked/include/RegisterFile_Internal_Banked.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_internal_banked    {

  void RegisterFile_Internal_Banked::vhdl_body (Vhdl * & vhdl)
  {
    vhdl->set_body   (0,"");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_comment(0," Ackitement");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_body   (0,"");

    for (uint32_t num_read=0; num_read<_param->_nb_port_read; ++num_read)
      vhdl->set_body   (0,"out_READ_"+toString(num_read)+"_ACK  <= '1';");
    for (uint32_t num_write=0; num_write<_param->_nb_port_write; ++num_write)
      vhdl->set_body   (0,"out_WRITE_"+toString(num_write)+"_ACK <= '1';");

    vhdl->set_body   (0,"");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_comment(0," Read RegisterFile");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_body   (0,"");

    if (_param->_size_ptr_write>0)
      for (uint32_t num_read=0; num_read<_param->_nb_port_read; ++num_read)
        {
#ifdef PTR_IS_REGFILE
          std::string str_address;
          if (_param->_have_port_address)
            str_address = "conv_integer(in_READ_"+toString(num_read)+"_ADDRESS)";
          else
            str_address = "0";

          vhdl->set_body   (0,"READ_NUM_BANK_"+toString(num_read)+" <= reg_PTR_WRITE("+str_address+");");
#else

          vhdl->set_body   (0,"with in_READ_"+toString(num_read)+"_ADDRESS select");
          vhdl->set_body   (1,"READ_NUM_BANK_"+toString(num_read)+" <=");
          for (uint32_t num_word=0; num_word<_param->_nb_word-1; ++num_word)
            vhdl->set_body   (1,"reg_PTR_WRITE_"+toString(num_word)+" when "+std_logic_cst(_param->_size_address,num_word)+",");
          vhdl->set_body   (1,"reg_PTR_WRITE_"+toString(_param->_nb_word-1)+" when others;");
#endif
        }
    vhdl->set_body   (0,"");

    for (uint32_t num_read=0; num_read<_param->_nb_port_read; ++num_read)
      {
	std::string str_address;
	if (_param->_have_port_address)
	  str_address = "conv_integer(in_READ_"+toString(num_read)+"_ADDRESS)";
	else
	  str_address = "0";

	vhdl->set_body   (0,"out_READ_"+toString(num_read)+"_DATA <=");
        for (uint32_t num_write=0; num_write<_param->_nb_port_write; ++num_write)
          {
            std::string str_ptr_write="";
            if (_param->_size_ptr_write>0)
              str_ptr_write = " and READ_NUM_BANK_"+toString(num_read)+" = "+std_logic_cst(_param->_size_ptr_write,num_write);

            vhdl->set_body   (1,"reg_DATA_"+toString(num_write)+"_"+toString(num_read)+"("+str_address+") when in_READ_"+toString(num_read)+"_VAL = '1'"+str_ptr_write+" else");
          }
        vhdl->set_body   (1,std_logic_others(_param->_size_word,0)+";");
      }

    vhdl->set_body   (0,"");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_comment(0," Write RegisterFile");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_body   (0,"");

    vhdl->set_body   (0,"RegisterFile_write: process (in_CLOCK)");
    vhdl->set_body   (0,"begin  -- process RegisterFile_write");
    vhdl->set_body   (1,"if in_CLOCK'event and in_CLOCK = '1' then");

    if (_param->_have_init_value)
      {
        vhdl->set_body   (2,"if in_NRESET = '0' then");
        
        std::string init_value = ((_param->_size_word>1)?"\"":"'")+_param->_init_value+((_param->_size_word>1)?"\"":"'");
        
        for (uint32_t num_word=0; num_word<_param->_nb_word; ++num_word)
          {
            for (uint32_t num_read=0; num_read<_param->_nb_port_read; ++num_read)
              vhdl->set_body   (3,"reg_DATA_0_"+toString(num_read)+"("+toString(num_word)+") <= "+init_value+";");

            if (_param->_size_ptr_write>0)
              {
#ifdef PTR_IS_REGFILE
                vhdl->set_body   (3,"reg_PTR_WRITE("+toString(num_word)+") <= "+std_logic_cst(_param->_size_ptr_write,0)+";");
#else
                vhdl->set_body   (3,"reg_PTR_WRITE_"+toString(num_word)+" <= "+std_logic_cst(_param->_size_ptr_write,0)+";");
#endif
              }
          }
        vhdl->set_body   (2,"else");
      }
    // else
    //   {
    //     vhdl->set_body   (2,"if in_NRESET = '0' then");
        
    //     for (uint32_t num_word=0; num_word<_param->_nb_word; ++num_word)
    //         if (_param->_size_ptr_write>0)
    //           vhdl->set_body   (3,"reg_PTR_WRITE("+toString(num_word)+") <= "+std_logic_cst(_param->_size_ptr_write,0)+";");
    //     vhdl->set_body   (2,"else");
    //   }
      
    
    for (uint32_t num_write=0; num_write<_param->_nb_port_write; ++num_write)
      {
	std::string str_address;
	if (_param->_have_port_address)
	  str_address = "conv_integer(in_WRITE_"+toString(num_write)+"_ADDRESS)";
	else
	  str_address = "0";

	vhdl->set_body   (2,"if (in_WRITE_"+toString(num_write)+"_VAL = '1') then");
        for (uint32_t num_read=0; num_read<_param->_nb_port_read; ++num_read)
          vhdl->set_body   (3,"reg_DATA_"+toString(num_write)+"_"+toString(num_read)+"("+str_address+") <= in_WRITE_"+toString(num_write)+"_DATA;");

        if (_param->_size_ptr_write>0)
          {
#ifdef PTR_IS_REGFILE
          vhdl->set_body   (3,"reg_PTR_WRITE("+str_address+") <= "+std_logic_cst(_param->_size_ptr_write,num_write)+";");
#else
          for (uint32_t num_word=0; num_word<_param->_nb_word; ++num_word)
            {
              vhdl->set_body   (3,"if (in_WRITE_"+toString(num_write)+"_ADDRESS = "+std_logic_cst(_param->_size_address,num_word)+") then");
              vhdl->set_body   (4,"reg_PTR_WRITE_"+toString(num_word)+" <= "+std_logic_cst(_param->_size_ptr_write,num_write)+";");
              vhdl->set_body   (3,"end if;");
            }
#endif
          }
	vhdl->set_body   (2,"end if;");
      }

    vhdl->set_body   (1,"end if;");

    if (_param->_have_init_value)
      vhdl->set_body   (1,"end if;");

    vhdl->set_body   (0,"end process RegisterFile_write;");
  };

}; // end namespace registerfile_internal_banked
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
