#ifndef morpheo_behavioural_generic_registerfile_registerfile_monolithic_RegisterFile_Monolithic
#define morpheo_behavioural_generic_registerfile_registerfile_monolithic_RegisterFile_Monolithic

/*
 * $Id: RegisterFile_Monolithic.h 145 2010-10-13 18:15:51Z rosiere $
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Common/include/Debug.h"
#include "Common/include/ToString.h"
#include <iostream>

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
// #include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"



namespace morpheo                    {
namespace behavioural                {

  class Component;
  class Interfaces;

namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

// #define VHDL_GAISLER

  typedef enum {RW_READ, RW_WRITE} rw_t;

  class RegisterFile_Monolithic 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const std::string       _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
    
  // private   : counter_t                      * _stat_nb_read;
  // private   : counter_t                      * _stat_nb_write;
  private   : counters_t                     * _stat_port_read;
  private   : counters_t                     * _stat_port_write;
  private   : counters_t                     * _stat_port_read_write;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN       (Tcontrol_t)      *  in_NRESET       ;

    // ----- Interface Read
  public    : SC_IN       (Tcontrol_t)     **  in_READ_VAL     ;
  public    : SC_OUT      (Tcontrol_t)     ** out_READ_ACK     ;
  public    : SC_IN       (Taddress_t)     **  in_READ_ADDRESS ;
  public    : SC_OUT      (Tdata_t)        ** out_READ_DATA    ;

    // ----- Interface Write
  public    : SC_IN       (Tcontrol_t)     **  in_WRITE_VAL    ;
  public    : SC_OUT      (Tcontrol_t)     ** out_WRITE_ACK    ;
  public    : SC_IN       (Taddress_t)     **  in_WRITE_ADDRESS;
  public    : SC_IN       (Tdata_t)        **  in_WRITE_DATA   ;

    // ----- Interface Read_Write
  public    : SC_IN       (Tcontrol_t)     **  in_READ_WRITE_VAL    ;
  public    : SC_OUT      (Tcontrol_t)     ** out_READ_WRITE_ACK    ;
  public    : SC_IN       (Tcontrol_t)     **  in_READ_WRITE_RW     ;
  public    : SC_IN       (Taddress_t)     **  in_READ_WRITE_ADDRESS;
  public    : SC_OUT      (Tdata_t)        ** out_READ_WRITE_RDATA  ;
  public    : SC_IN       (Tdata_t)        **  in_READ_WRITE_WDATA  ;

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : Tdata_t * reg_DATA;

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (RegisterFile_Monolithic);
#endif					       
  public  : RegisterFile_Monolithic
  (
#ifdef SYSTEMC
   sc_module_name                              name
#else					       
   std::string                                      name
#endif					       
#ifdef STATISTICS
   ,morpheo::behavioural::Parameters_Statistics * param_statistics
#endif
   ,Parameters                                  * param
   ,morpheo::behavioural::Tusage_t                usage
   );

  public  :          ~RegisterFile_Monolithic  (void);
					       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void     constant                  (void);
  public  : void     transition                (void);
//public  : void     genMoore                  (void) {/* empty */};
  public  : void     genMealy_read             (void);
#endif					       

#ifdef STATISTICS
  public  : void     statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif					       

#if VHDL				       
  private : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void     end_cycle                 (void);
#endif
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
