#ifdef VHDL

/*
 * $Id: Vhdl_get_model.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Tabulation.h"
#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
  std::string Vhdl::get_model(uint32_t depth                 ,
                              std::string   filename         ,
                              std::string   entity_name      )
  {
    log_printf(FUNC,Behavioural,"get_model","Begin");

    std::string        tab = morpheo::tab(depth);
    std::ostringstream text;

    std::string configuration_name = "configuration_"+entity_name;

    text << tab << get_header       (depth,filename)    << std::endl
	 << tab << get_library      (depth)             << std::endl
	 << tab << get_entity       (depth,entity_name) << std::endl
	 << tab << get_architecture (depth,entity_name) << std::endl
         << tab << get_configuration(depth,entity_name,configuration_name) << std::endl
      ;
    
    log_printf(FUNC,Behavioural,"get_model","End");

    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
