/*
 * $Id: Read_unit.cpp 146 2011-02-01 20:57:54Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/include/Read_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit::Read_unit"
  Read_unit::Read_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Read_unit,FUNCTION,_("<%s> Begin"),_name.c_str());

// #if DEBUG_Read_unit == true
//     log_printf(INFO,Read_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Read_unit,FUNCTION,_("<%s> Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Read_unit,FUNCTION,_("<%s> Allocation of statistics"),_name.c_str());

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Read_unit,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Read_unit,FUNCTION,_("<%s> Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
      }
# endif
#endif
    log_printf(FUNC,Read_unit,FUNCTION,_("<%s> End"),_name.c_str());
  };
    
#undef  FUNCTION
#define FUNCTION "Read_unit::~Read_unit"
  Read_unit::~Read_unit (void)
  {
    log_printf(FUNC,Read_unit,FUNCTION,_("<%s> Begin"),_name.c_str());

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Read_unit,FUNCTION,_("<%s> Generate Statistics file"),_name.c_str());
	
	delete _stat;
      }
#endif

    log_printf(INFO,Read_unit,FUNCTION,_("<%s> Deallocation"),_name.c_str());
    deallocation ();

    log_printf(FUNC,Read_unit,FUNCTION,_("<%s> End"),_name.c_str());
  };

}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
