#ifdef SYSTEMC
/*
 * $Id: Reexecute_unit_must_reexecute.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Reexecute_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace reexecute_unit {


#undef  FUNCTION
#define FUNCTION "Reexecute_unit::must_reexecute"
  bool Reexecute_unit::must_reexecute (Tspr_address_t address, info_t & info)
  {
    log_begin(Reexecute_unit,FUNCTION);

    // Test if need reexecute
    if (info.spr_wen)
      {
	// ***** SPR WRITE *****
	
	Tspr_address_t num_group = (address >> _param->_shift_spr_num_group) & _param->_mask_spr_num_group;
	Tspr_address_t num_reg   = (address                                ) & _param->_mask_spr_num_reg  ;
	
	switch (num_group)
	  {
	  case GROUP_DCACHE :
	    {
	      info.type     = TYPE_MEMORY;
	      info.write_rd = 0;
	      
	      switch (num_reg)
		{
		case SPR_DCBPR : {info.reexecute = true; info.operation = OPERATION_MEMORY_PREFETCH  ; break;}
		case SPR_DCBFR : {info.reexecute = true; info.operation = OPERATION_MEMORY_FLUSH     ; break;}
		case SPR_DCBIR : {info.reexecute = true; info.operation = OPERATION_MEMORY_INVALIDATE; break;}
// 		case SPR_DCBWR : {info.reexecute = true; info.operation = OPERATION_MEMORY_FLUSH     ; break;}
		case SPR_DCBLR : {info.reexecute = true; info.operation = OPERATION_MEMORY_LOCK      ; break;}
		default :
		  {
		    info.reexecute = false;
		    break;
		  }
		}
	      
	      break;
	    }
	  default :
	    {
	      info.reexecute = false;
	      break;
	    }
	  }
      }
    else
      {
	// ***** SPR READ *****
	info.reexecute = true;
	info.type      = TYPE_ALU;
	info.operation = OPERATION_ALU_L_OR;
	info.write_rd  = 1;
      }

    log_end(Reexecute_unit,FUNCTION);

    return info.reexecute;
  }
  
}; // end namespace reexecute_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif


