/*
 * $Id: top.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Queue/SelfTest/include/top.h"
#include "Behavioural/include/Selftest.h"

#define NB_PARAMS 5

#ifdef MTI_SYSTEMC
SC_MODULE_EXPORT(top);
#endif

#ifdef MTI_SYSTEMC
SC_CTOR(top::top)
#else
top::top (sc_module_name module_name, int argc, char * argv[])
#endif
{
#ifdef MTI_SYSTEMC
  // accessing command-line arguments with modelsim
  int argc;
  const char * const * argv;

  argc = sc_argc ();
  argv = sc_argv ();
#endif

  if (argc != 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t size_queue     ;
  uint32_t size_data      ;
  uint32_t nb_port_slot   ;
  bool     have_port_write;
  bool     have_port_read ;

  uint32_t x=1;

  SELFTEST0(name           ,string  ,argv,x);
  SELFTEST0(size_queue     ,uint32_t,argv,x);
  SELFTEST0(size_data      ,uint32_t,argv,x);
  SELFTEST0(nb_port_slot   ,uint32_t,argv,x);
  SELFTEST0(have_port_write,bool    ,argv,x);
  SELFTEST0(have_port_read ,bool    ,argv,x);

  _param = new morpheo::behavioural::generic::queue::Parameters
    (
      size_queue
     ,size_data 
     ,nb_port_slot
     ,have_port_write
     ,have_port_read
//   ,true
     );
  
  // msg(_("%s"),_param.print(0).c_str());
  
  // Allocation component
  allocation ();
  
#ifdef MTI_SYSTEMC
  SC_THREAD(test);
#endif
}

top::~top (void)
{
  deallocation ();
  delete _param;
}
