#ifndef morpheo_behavioural_generic_registerfile_Parameters_h
#define morpheo_behavioural_generic_registerfile_Parameters_h

/*
 * $Id: Parameters.h 146 2011-02-01 20:57:54Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile/RegisterFile_Internal_Banked/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/Parameters.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace generic {
namespace registerfile {

  typedef enum {instance_RegisterFile_Monolithic,
		instance_RegisterFile_Internal_Banked,
		instance_RegisterFile_Multi_Banked} Tinstance_t;

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : Tinstance_t _instance;
  public : uint32_t    _nb_port_read ;
  public : uint32_t    _nb_port_write;
  public : uint32_t    _nb_word      ;
  public : uint32_t    _size_word    ;
  public : uint32_t    _size_address ;
  public : bool        _have_port_address;

  public : morpheo::behavioural::generic::registerfile::registerfile_monolithic     ::Parameters * _param_registerfile_monolithic;
  public : morpheo::behavioural::generic::registerfile::registerfile_internal_banked::Parameters * _param_registerfile_internal_banked;
  public : morpheo::behavioural::generic::registerfile::registerfile_multi_banked   ::Parameters * _param_registerfile_multi_banked;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (morpheo::behavioural::generic::registerfile::registerfile_monolithic     ::Parameters * param);
  public : Parameters  (morpheo::behavioural::generic::registerfile::registerfile_internal_banked::Parameters * param);
  public : Parameters  (morpheo::behavioural::generic::registerfile::registerfile_multi_banked   ::Parameters * param);
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void             copy       (void);

  public :        Parameters_test  msg_error  (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
				       morpheo::behavioural::generic::registerfile::Parameters & x);
  };

}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
