// #ifdef STATISTICS
#include "Behavioural/include/Stat_binary_tree.h"
#include "Common/include/Tabulation.h"

namespace morpheo {
namespace behavioural {

  void Stat_binary_tree::print (uint32_t depth)
  {
    std::string tab = morpheo::tab(depth);
    std::string sep = " ";
    if (_data_type == NONE)
      {
        std::cout << tab << "<node> NONE (error)" << std::endl;

        if (_left  != NULL)
          _left ->print(depth+1);
        if (_right != NULL)
          _right->print(depth+1);
      }

    if ((_data_type == VARIABLE) or
	(_data_type == CONSTANT))
      {
        std::cout << tab << "<leaf>"
                  << " "
                  << ((_left   == NULL)?"left  == NULL        ":"left  != NULL (error)")
                  << " "
                  << ((_right  == NULL)?"right == NULL        ":"right != NULL (error)")
                  << std::endl;

        if (_left  != NULL)
          _left ->print(depth+1);
        if (_right != NULL)
          _right->print(depth+1);
      }
    
    if (_data_type == OPERATOR_UNARY)
      {
        std::cout << tab << "<unary>"
                  << " "
                  << ((_left   == NULL)?"left  == NULL (error)":"left  != NULL        ")
                  << " "
                  << ((_right  == NULL)?"right == NULL        ":"right != NULL (error)")
                  << std::endl;
        
        if (_left  != NULL)
          _left ->print(depth+1);
        if (_right != NULL)
          _right->print(depth+1);
      }

    if (_data_type == OPERATOR_BINARY)
      {
        std::cout << tab << "<binary>"
                  << " "
                  << ((_left   == NULL)?"left  == NULL (error)":"left  != NULL        ")
                  << " "
                  << ((_right  == NULL)?"right == NULL (error)":"right != NULL        ")
                  << std::endl;

        if (_left  != NULL)
          _left ->print(depth+1);
        if (_right != NULL)
          _right->print(depth+1);
      }
  }

};
};
// #endif
