#ifdef VHDL

/*
 * $Id: Vhdl_generate_file_package.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Environment.h"
#include <sstream>
#include <fstream>

namespace morpheo              {
namespace behavioural          {

  void Vhdl::generate_file_package(void)
  {
    log_printf(FUNC,Behavioural,"generate_file_package","Begin");

    directory();

    std::string name     = _name + "_Pack";
    std::string filename = MORPHEO_VHDL + "/" + name + VHDL_EXTENSION;

    msg_printf(INFORMATION,_("Generate file \"%s\"."),filename.c_str());

    std::ofstream file;
    file.open(filename.c_str(),std::ios::out | std::ios::trunc);

    file << get_package (0,filename, name, _name);

    file.close();

    log_printf(FUNC,Behavioural,"generate_file_package","End");
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
