#!/bin/bash

#-----------------------------------------------------------
# $Id: instruction_flow_diff.sh 122 2009-06-03 08:15:51Z rosiere $
#-----------------------------------------------------------

#-----[ usage ]---------------------------------------------
function usage ()
{
    echo "Usage     : ${0} file1 file2";
    echo "Arguments : ";
    echo " * file1 : instruction flow file 1 (original)";
    echo " * file2 : instruction flow file 2";
    exit;
}

#-----[ test_usage ]----------------------------------------
function test_usage ()
{
    if test ${#} -ne 2; then
        usage ${*};
    fi;

    if test ! -f ${1} -o ! -f ${2}; then
        usage ${*};
    fi;
}

#-----[ main ]----------------------------------------------
function main ()
{
    test_usage ${*};

    # Read symbol file and take function address and function name
    local -a array1_address;
    local -a array1_load_data;
    local -i cpt1;
    local -i cpt2;
    local    address1;
    local    address2;

     # Read instruction flow file 1
    cpt1=0;
    while read line; do
        if test $(echo "${line}" |grep -c "OK") -gt 0; then
            # extract address
            address1=$(echo ${line} | cut -d' ' -f2);
            load_data1=$(echo ${line} | cut -d' ' -f7);
          
            array1_address[${cpt1}]=${address1};
            array1_load_data[${cpt1}]=${load_data1};

            cpt1=$((${cpt1}+1));
        fi;
    done < ${1};

     # Read instruction flow file 2 and compare with flow 1
    cpt1=0;
    cpt2=1;
    address1=${array1_address[${cpt1}]};
    load_data1=${array1_load_data[${cpt1}]};

    while read line; do
        if test $(echo "${line}" |grep -c "OK") -gt 0; then

            if test ${cpt1} -eq ${#array1_address[*]}; then
                echo "file \"${1}\" is empty, not file \"${2}\".";
                exit;
            fi;

            # extract address
            address2=$(echo ${line} | cut -d' ' -f2);
            load_data2=$(echo ${line} | cut -d' ' -f7);

            # test address
            if test "${address1}" != "${address2}"; then
                echo "diff line ${cpt2} on address:";
                echo "${line}";
                exit;
            fi;

            if test "${load_data1}" != "${load_data2}"; then
                echo "diff line ${cpt2} on load_data:";
                echo "${line}";
                exit;
            fi;

            cpt1=$((${cpt1}+1));
            address1=${array1_address[${cpt1}]};
            load_data1=${array1_load_data[${cpt1}]};

        fi;
        cpt2=$((${cpt2}+1));
    done < ${2};

    if test ${cpt1} -ne ${#array1_address[*]}; then
        echo "file \"${2}\" is empty, not file \"${1}\".";
        exit;
    else
        echo "no diff.";
    fi;

}

#-----[ Corps ]---------------------------------------------
main ${*};
