#ifndef morpheo_behavioural_generic_registerfile_registerfile_multi_banked_registerfile_multi_banked_glue_Parameters_h
#define morpheo_behavioural_generic_registerfile_registerfile_multi_banked_registerfile_multi_banked_glue_Parameters_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Include/Debug.h"
#include "Include/FromString.h"
#include "Behavioural/include/Parameters.h"
#include <math.h>

namespace morpheo {

  typedef enum {PARTIAL_CROSSBAR,
		FULL_CROSSBAR   } Tcrossbar_t;

  template<> inline Tcrossbar_t fromString<Tcrossbar_t> (const std::string& x)
  {
    if ( (x.compare("0")                == 0) or
	 (x.compare("PARTIAL_CROSSBAR") == 0))
      return PARTIAL_CROSSBAR;
    if ( (x.compare("1")                == 0) or
	 (x.compare("FULL_CROSSBAR"   ) == 0))
      return FULL_CROSSBAR;

    throw (ErrorMorpheo ("<fromString> : Unknow string : \""+x+"\""));
  }
  
  template<> inline std::string toString<Tcrossbar_t>   (const Tcrossbar_t& x)
  {
    ostringstream out;

    if (x == PARTIAL_CROSSBAR)
      out << "PARTIAL_CROSSBAR";
    if (x == FULL_CROSSBAR)
      out << "FULL_CROSSBAR";

    return out.str();
  }

namespace behavioural {
namespace generic {
namespace registerfile{
namespace registerfile_multi_banked {
namespace registerfile_multi_banked_glue {
      
  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t    _nb_port_read         ;
  public : const uint32_t    _nb_port_write        ;
  public : const uint32_t    _size_address         ;
  public : const uint32_t    _size_word            ;
  public : const uint32_t    _nb_bank              ;
  public : const uint32_t    _nb_port_read_by_bank ;
  public : const uint32_t    _nb_port_write_by_bank;
  public : const Tcrossbar_t _crossbar             ;

  public : const uint32_t    _shift_address        ;

  public :       uint32_t  * _link_port_read       ; 
  public :       uint32_t  * _link_port_write      ;

  public :       uint32_t  * _nb_port_select_by_bank_read_port ;
  public :       uint32_t  * _nb_port_select_by_bank_write_port;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t    nb_port_read         ,
			uint32_t    nb_port_write        ,
			uint32_t    size_address         ,
			uint32_t    size_word            ,
			uint32_t    nb_bank              ,
			uint32_t    nb_port_read_by_bank ,
			uint32_t    nb_port_write_by_bank,
			Tcrossbar_t crossbar             );

  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public : string msg_error (void);

  public :        string   print      (uint32_t depth);
  public : friend ostream& operator<< (ostream& output_stream,
				       morpheo::behavioural::generic::registerfile::registerfile_multi_banked::registerfile_multi_banked_glue::Parameters & x);
  };

}; // end namespace registerfile_multi_banked_glue
}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
