#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Select/Select_Priority_Fixed/include/Select_Priority_Fixed.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace select {
namespace select_priority_fixed {


  void Select_Priority_Fixed::allocation (void)
  {
    string rename;

    log_printf(FUNC,Select_Priority_Fixed,"allocation","Begin");

     in_CLOCK        = new SC_CLOCK           ("in_CLOCK ");
     in_NRESET       = new SC_IN (Tcontrol_t) ("in_NRESET");

     in_VAL          = new SC_IN (Tcontrol_t)           * [_param._nb_entity];
    if (_param._encoding_one_hot)
    out_ACK          = new SC_OUT(Tcontrol_t)           * [_param._nb_entity];

    for (uint32_t i=0; i<_param._nb_entity; i++)
      {
	rename = " in_VAL_"+toString(i);
	 in_VAL [i]      = new SC_IN (Tcontrol_t) (rename.c_str());

	if (_param._encoding_one_hot)
	  {
	rename = "out_ACK_"+toString(i);
	out_ACK [i]      = new SC_OUT(Tcontrol_t) (rename.c_str());
	  }
      }

    if (_param._encoding_compact)
      {
	out_ENTITY_ACK   = new SC_OUT(Tcontrol_t)           ("out_entity_ack");
	out_ENTITY       = new SC_OUT(Tentity_t)            ("out_entity");
      }
    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    log_printf(FUNC,Select_Priority_Fixed,"allocation","End");
  };

}; // end namespace select_priority_fixed
}; // end namespace select
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
