/********************************************
 * files               : asm_002_addc.s
 * authors             : Rosiere Mathieu
 * date                : 2006/06/20
 ********************************************
 * input               : -
 * output              : 1 test OK
 *                       0 test KO
 ********************************************
 * test                : Test the carry
 * warning             : instructions used
 *                         l.add
 *                         l.addi
 *                         l.and
 *                         l.bf
 *                         l.jal
 *                         l.jr
 *                         l.sfne              
 ********************************************
 */
	.file	"asm_002_addc.s"
	.section .text
	.align	4

	.global _asm_002_addc
_asm_002_addc :	
	/* save context */
	l.addi	r1,r1,-12
	l.sw	0(r1),r20
	l.sw	4(r1),r21
	l.sw	8(r1),r22
	/* Return is KO (default) */
	l.and   r11,r0,r0

	/*
	 * R20 = 0x00000001
	 * R21 = 0xFFFFFFFF
	 * R22 = 0x00000000 and carry is set
	 */
	l.addi	r20,r0, 1
	l.addi	r21,r0,-1
	l.add	r22,r20,r21

	/* Add the carry */
	l.addc	r22,r0,r0
	
	l.sfne	r22,r20
	l.bf	_asm_002_addc_ko
	l.nop	0
	
_asm_002_addc_ok :	
	l.addi	r11,r0,1

_asm_002_addc_ko :
	/* load context */
	l.lwz	r22,8(r1)
	l.lwz	r21,4(r1)
	l.lwz	r20,0(r1)
	l.jr	r9
	l.addi	r1,r1,12
