#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Meta_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {


  void Meta_Predictor::vhdl_testbench_transition ()
  {
    log_printf(FUNC,Meta_Predictor,"vhdl_testbench_transition","Begin");

    // Evaluation before read the ouput signal
    sc_start(0);

    // In order with file Meta_Predictor_vhdl_testbench_port.cpp
    // Warning : if a output depend of a subcomponent, take directly the port of subcomponent
    // (because we have no control on the ordonnancer's policy)

    _vhdl_testbench->add_input (PORT_READ( in_NRESET));

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	_vhdl_testbench->add_input (PORT_READ( in_PREDICT_VAL                          [i]));
	_vhdl_testbench->add_output(PORT_READ(out_PREDICT_ACK                          [i]));
	_vhdl_testbench->add_input (PORT_READ( in_PREDICT_ADDRESS                      [i]));
	_vhdl_testbench->add_output(PORT_READ(out_PREDICT_HISTORY                      [i]));
	_vhdl_testbench->add_output(PORT_READ(out_PREDICT_DIRECTION                    [i]));
      }

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	_vhdl_testbench->add_input (PORT_READ( in_BRANCH_COMPLETE_VAL                  [i]));
	_vhdl_testbench->add_output(PORT_READ(out_BRANCH_COMPLETE_ACK                  [i]));
	_vhdl_testbench->add_input (PORT_READ( in_BRANCH_COMPLETE_ADDRESS              [i]));
	_vhdl_testbench->add_input (PORT_READ( in_BRANCH_COMPLETE_HISTORY              [i]));
	_vhdl_testbench->add_input (PORT_READ( in_BRANCH_COMPLETE_DIRECTION            [i]));
      }
    
    // add_test :
    //  - True  : the cycle must be compare with the output of systemC
    //  - False : no test
    _vhdl_testbench->add_test(true);

    _vhdl_testbench->new_cycle (); // always at the end

    log_printf(FUNC,Meta_Predictor,"vhdl_testbench_transition","End");
  };

}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
