/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {


  Parameters::Parameters (uint32_t nb_port_read ,
			  uint32_t nb_port_write,
			  uint32_t nb_word      ,
			  uint32_t size_word    ,
			  uint32_t nb_bank      ):
    _nb_port_read  (nb_port_read ),
    _nb_port_write (nb_port_write),
    _nb_word       (nb_word      ),
    _size_word     (size_word    ),
    _nb_bank       (nb_bank      ),
    _size_address  (static_cast<uint32_t>(ceil(log2(_nb_word))))
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"Parameters","Begin");
    test();
    log_printf(FUNC,RegisterFile_Multi_Banked,"Parameters","End");
  };
  
  Parameters::Parameters (Parameters & param):
    _nb_port_read  (param._nb_port_read ),
    _nb_port_write (param._nb_port_write),
    _nb_word       (param._nb_word      ),
    _size_word     (param._size_word    ),
    _nb_bank       (param._nb_bank      ),
    _size_address  (param._size_address )
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"Parameters","Begin");
    test();
    log_printf(FUNC,RegisterFile_Multi_Banked,"Parameters","End");
  };

  Parameters::~Parameters () 
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"~Parameters","Begin");
    log_printf(FUNC,RegisterFile_Multi_Banked,"~Parameters","End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
