#include "window.h"

using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;

void Window::paintEvent( QPaintEvent * )
{
    
  /*draw window size*/
  setMinimumSize(600,600);
    
  if(paint){

    painter.begin(this);
    painter.setPen(Qt::blue);
    painter.drawRect(margeX,margeY,margeX+450,margeY+450);
    
    for(QList<Port>::iterator it=port_east.begin(); it!=port_east.end(); ++it){
      portX = it->get_x();
      portY = it->get_y();
      drawPort(portX + margeX,portY + margeY ,EAST,it->getDirection());
    } 
    
    for(QList<Port>::iterator it=port_west.begin(); it!=port_west.end(); ++it){
      portX = it->get_x() ;
      portY = it->get_y() ;
      drawPort(portX + margeX,portY + margeY, WEST, it->getDirection());
    }

    for(QList<Port>::iterator it=port_north.begin(); it!=port_north.end(); ++it){
      portX = it->get_x() ;
      portY = it->get_y() ;
      drawPort(portX + margeX ,portY+margeY,NORTH,it->getDirection());
    }

    for(QList<Port>::iterator it=port_south.begin(); it!=port_south.end(); ++it){
      portX = it->get_x() ;
      portY = it->get_y() ;
      drawPort(portX + margeX,portY+margeY,SOUTH,it->getDirection());
    }


    if(p.getArchitecture()!=NULL){
      compo = p.getComponent();
      for(QList<Component>::iterator it=compo->begin();it!=compo->end();++it){
	Coord *co = it->get_Position();
	posX = co->get_hg_x()+margeX;
	posY = co->get_hg_y()+margeY;
	tailleX = co->get_size_x();
	tailleY = co->get_size_y();
	painter.drawRect(posX,posY,tailleX,tailleY);
	Coord *co2=new Coord( co->get_hg_x() + tailleX/2, co->get_hg_y() + tailleY/2,tailleX/2,tailleY/2);
	QList<Port> ports2=(it->getPortEast(co2));
	for (QList<Port>::iterator it2=ports2.begin();it2!=ports2.end();++it2) 
	  {
	    
	    portX =it2->get_x();
	    portY =it2->get_y();
	    drawPort(portX + margeX,portY+margeY , EAST,it2->getDirection());
	  }
	ports2=(it->getPortWest(co));
	for (QList<Port>::iterator it2=ports2.begin();it2!=ports2.end();++it2) 
	  {
	    
	    portX =it2->get_x();
	    portY =it2->get_y();
	    drawPort(portX + margeX ,portY+margeY ,WEST,it2->getDirection());
	  }
	ports2=(it->getPortNorth(co));
	for (QList<Port>::iterator it2=ports2.begin();it2!=ports2.end();++it2) 
	  {
	    
	    portX =it2->get_x();
	    portY =it2->get_y();
	    drawPort(portX + margeX ,portY+margeY,NORTH,it2->getDirection());
	    
	  }
	ports2=(it->getPortSouth(co));
	for (QList<Port>::iterator it2=ports2.begin();it2!=ports2.end();++it2) 
	  {
	    
	    portX =it2->get_x();
	    portY =it2->get_y();
	    drawPort(portX + margeX ,portY+margeY,SOUTH,it2->getDirection());

	  }
	painter.setPen(Qt::red);
        QList<PortMap> *pm=it->getPortMap();
	//init_grid();
	for (QList<PortMap>::iterator it3=pm->begin();it3!=pm->end();++it3) 
	  {
	    Signal *s=base->getSignal(it->getType(),new PortMap(*it3));
	    painter.drawLine(s->get_src_x()+margeX,s->get_src_y()+margeY,s->get_dest_x()+margeX,s->get_dest_y()+margeY);
            //p1 = new Point(s->get_src_x()+2*margeX,s->get_src_y()+2*margeY,NULL,FREE,0); 
	    //p2 = new Point(s->get_dest_x()+margeX,s->get_dest_y()+margeY,NULL,FREE,0);
	   // grid[p1->getX()][p1->getY()] = p1;
	    //grid[p2->getX()][p2->getY()] = p2;
	    
	    
	    //drawSignal(p1,p2);
            //p1 = NULL;p2 = NULL;
	  }
        painter.setPen(Qt::blue);
      }
    }
    painter.end();
    
    
  }
}

void Window::repaint(){
}

