/*
 * $Id$
 *
 * [Description ]
 * 
 * Test
 */

#define NB_ITERATION 1

#define LABEL(str) do {cout << "{"+toString(static_cast<uint32_t>(sc_simulation_time()))+"} " << str << endl; _@COMPONENT->vhdl_testbench_label(str);} while (0)

#include "Behavioural/@DIRECTORY/SelfTest/include/test.h"
#include "Include/Test.h"

void test (string name,
	   morpheo::behavioural::@NAMESPACE_USE::Parameters _param)
{
  cout << "<" << name << "> : Simulation SystemC" << endl;

  @COMPONENT * _@COMPONENT = new @COMPONENT (name.c_str(),
#ifdef STATISTICS
					     morpheo::behavioural::Parameters_Statistics(5,50),
#endif
					     _param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  sc_clock                               * CLOCK;
  sc_signal<Tcontrol_t>                  * NRESET;

  string rename;

  CLOCK                                  = new sc_clock ("clock", 1.0, 0.5);
  NRESET                                 = new sc_signal<Tcontrol_t> ("NRESET");
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of _@COMPONENT" << endl;
  
  (*(_@COMPONENT->in_CLOCK))        (*(CLOCK));
  (*(_@COMPONENT->in_NRESET))       (*(NRESET));


  cout << "<" << name << "> Start Simulation ............" << endl;

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  sc_start(0);
  LABEL("Initialisation");

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration "+toString(iteration));

      sc_start(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  cout << "<" << name << "> ............ Stop Simulation" << endl;

  delete CLOCK;
  delete NRESET;
#endif

  delete _@COMPONENT;
}
