#include "ramlock.h"
#include <iostream>

using namespace hierarchy_memory::ramlock;
using namespace std;

void test_ko (int val)
{
  cout << "***** Test(" << val << ") KO *****" << endl;
  exit (val);
}

void test_ok ()
{
  cout << "***** Test OK *****" << endl;
  exit (0);
}

int main ()
{
  cout << "<main> Test de \"Ramlock\"" << endl;
  
  cout << "  * Create a Ramlock with a size of 70" << endl;

  Ramlock my_ramlock = Ramlock(param_t("my_ramlock",70));
  my_ramlock.reset();

  cout << my_ramlock << endl;

  if (my_ramlock.read (10) != UNLOCK) test_ko(1);  cout << my_ramlock << endl;
  if (my_ramlock.read (10) !=   LOCK) test_ko(2);  cout << my_ramlock << endl;
  if (my_ramlock.write(10) !=   LOCK) test_ko(3);  cout << my_ramlock << endl;
  if (my_ramlock.write(10) != UNLOCK) test_ko(4);  cout << my_ramlock << endl;

  test_ok ();
}
